package com.ibm.ulc.vaedit;

/**
 * This document makes sure that only one character is ever entered into the document.
 * Also, since accelerators can't be lowercase A-Z, this will also change it to uppercase.
 * Creation date: (08-20-99 4:51:54 PM)
 * @author: 
 */
import javax.swing.text.*;

public class UlcAcceleratorEditorDocument extends PlainDocument {
/**
 * UlcSingleCharDocument constructor comment.
 */
public UlcAcceleratorEditorDocument() {
	super();
}
/**
 * UlcSingleCharDocument constructor comment.
 * @param c javax.swing.text.AbstractDocument.Content
 */
protected UlcAcceleratorEditorDocument(javax.swing.text.AbstractDocument.Content c) {
	super(c);
}
/**
 * Insert a string, but only one char (the last char), and wipe out any already in document.
 * Also, if it is a lowercase ascii letter (a-z), convert to upper case since lowercase not
 * permitted for accelerators (it actually conflicts with VK_numpad codes).
 * Creation date: (08-20-99 4:54:30 PM)
 * @param offset int
 * @param str java.lang.String
 * @param a javax.swing.text.AttributeSet
 * @exception javax.swing.text.BadLocationException The exception description.
 */
public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
	if (getLength() > 0)
		remove(0, getLength());
	if (str.length() > 0) {
		char theChar = str.charAt(0);
		if (theChar >= 'a' && theChar <= 'z')
			theChar = Character.toUpperCase(theChar);
		super.insertString(0, String.valueOf(theChar), a);
	} else
		super.insertString(0, str, a);
}
}
