package com.ibm.ulc.util;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.*;

/**
 * Instances of classes that implement this interface are used to stream Anythings
 * from an InputStream in a specific format.
 */
public interface IAnythingReader {
	/**
	 * Creates the corresponding writer for this format
	 */
	public IAnythingWriter createWriter();
/**
 * @return	<code>true</code> if push back data is stored in the reader; <code>false</code> otherwise
 * @since ULC R3.1
 */
public boolean hasPutBack();
/**
 * Store an initial value in the reader. This value
 * is the first one that the reader uses upon the next
 * read (even before going to its stream
 *
 * @param c		the value which is pushed back
 * @since ULC R3.1
 */
public void putBack(int c);
	public Anything read(InputStream is);
public Anything readEx(InputStream is) throws IOException;
}
