package com.ibm.ulc.ui.lists;

import javax.swing.plaf.ColorUIResource;
/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import com.ibm.ulc.ui.base.*;
public class UiTableCellRenderer extends DefaultTableCellRenderer implements IAboutToPaintListener, TableCellRenderer {
	protected JComponent fComponent;
	protected Object fCell = null;
	protected int fRow, fCol;
	protected JTable fTable;
	private	Color fForegroundColor= null;
	private	Color fBackgroundColor= null;	
public UiTableCellRenderer(JComponent renderer) {
	super();
	fComponent= renderer;
	Color c= renderer.getBackground();
	if (! (c instanceof ColorUIResource))
		fBackgroundColor= c;
	else
		fBackgroundColor= UIManager.getColor("Table.background");
	c= renderer.getForeground();
	if (! (c instanceof ColorUIResource))
		fForegroundColor= c;
	else
		fForegroundColor= UIManager.getColor("Table.foreground");
}
public void aboutToPaint() {
	if (fTable != null && fCell instanceof InvalidCell) {
		if (fTable instanceof UiJTable)
			 ((UiJTable) fTable).requestString(fRow, fCol);
	}
}
public void free() {
	fTable = null;
	fComponent = null;
}
public JComponent getComponent() {
	return fComponent;
}
public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int col) {
	fCell = o;
	fRow = row;
	fCol = col;
	if (table != null)
		fTable = (JTable) table;
	else
		fTable = null;
	JComponent component= getComponent();
	if (component instanceof IRenderer) {
		IRenderer ir = (IRenderer) component;
		Object object = o;
		if (o == null)
			object = new String();
		ir.configureAsRenderer(table, this, object, isSelected);
	}
	if (!isSelected) {
		component.setOpaque(true);
	    component.setForeground(fForegroundColor);
	   	component.setBackground(fBackgroundColor);
	}
	return component;
}
public JTable getTableWidget() {
	return fTable;
}
public void updateUI() {
	super.updateUI();
	if (fComponent != null) {
		fComponent.updateUI();
	}
}
}
