package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
/**
 * PendingNode is a placeholder for TreeModel nodes.
 * It is inserted into the model when any node is expanded, 
 * and the UI is waiting for the reply from the ULC side.
 * It also need to know it's parent since the lazy-rendering
 * process needs this.
 */
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.comm.Common;
import com.ibm.ulc.util.Anything;

public class UiPendingRow extends UiInvalidRow implements IRow {
	protected int fOid = -1;
	protected UlcHashtable fData = new UlcHashtable();
/**
 * Create and answer a new instance that is defined to be item number 
 * <code>index</code> of some <code>UIItemList</code>
 *
 * @param index 	the position of the receiver in the items of an <code>UIItemList</code>
 */
public UiPendingRow(int index) {
	fOid = index;
}
/**
 * answer the receiver's object identifier (oid)
 */
public IRow asNonPendingRow(UiItemCache cache, int oid) {
	fOid = oid;
	IRow answer = super.asNonPendingRow(cache, oid);
	answer.updateData(cache, fData);
	return answer;
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getExistingValueAt(String attributeName, UiItemCache cache) {
	Object answer = fData.get(attributeName);
	if (answer == null && !fData.containsKey(attributeName)) {
		answer = super.getExistingValueAt(attributeName, cache);
	}
	return answer;
}
/**
 * answer the receiver's object identifier (oid)
 */
public int getOid() {
	return fOid;
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getValueAt(String attributeName, UiItemCache cache) {
	Object answer = fData.get(attributeName);
	if (answer == null && !fData.containsKey(attributeName)) {
		answer = cache.requestAttribute(getOid(), attributeName);
		fData.put(attributeName, answer);
	}
	return answer;
}
/**
 * answer true, if the receiver's value for @atttributeName is equal to value
 *
 */
public boolean isValue(String attributeName, Object value) {
	Object object = fData.get(attributeName);
	if (object == null)
		return false;
	else
		return object.equals(value);
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
protected void resetValue(String attributeName) {
	fData.remove(attributeName);
}
public void resetValues() {
	fData.clear();
}
public void resetValues(UiItemCache cache) {
	resetValues();
	super.resetValues(cache);
}
/**
 * Set the data directly without trashing the edit cache.
 */
public void setData(UITableModel tableModel, Anything attributeNames, Anything attributeValues) {
	if (attributeNames == null)
		return;
	for (int i = 0; i < attributeNames.size(); i++) {
		Object value = tableModel.convert(tableModel.getConnection(), attributeValues.get(i));
		fData.put(attributeNames.get(i).asString("null"), value);
	}
}
/**
 * Set the data directly without trashing the edit cache.
 */
public void setData(Anything attributeNames, Anything attributeValues) {
	if (attributeNames == null)
		return;
	for (int i = 0; i < attributeNames.size(); i++) {
		Object value = Common.convertFromAnything(attributeValues.get(i));
		fData.put(attributeNames.get(i).asString("null"), value);
	}
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void setValue(UiItemCache cache, String attributeName, Object value) {
	fData.put(attributeName, value);
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void update(IRow anotherRow) {
}
}
