package com.ibm.ulc.ui.lists;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

public class UITreeColumn extends UIColumn {
	protected boolean fIsEditable;
/**
 * Need to repaint the table, but no direct access
 * to the table is available.
 */
protected UiTreeCellRenderer getTreeCellRenderer() {
	return (UiTreeCellRenderer) getTreeRenderer().getCellRenderer();
}
/**
 * Need to repaint the table, but no direct access
 * to the table is available.
 */
protected UiTreeTableCellRenderer getTreeRenderer() {
	return (UiTreeTableCellRenderer) getTableColumn().getCellRenderer();
}
protected void initializeFor(JTable table) {
	super.initializeFor(table);
	UiTableColumn col = getTableColumn();
	TableCellRenderer renderer = table.getDefaultRenderer(TreeModel.class);
	col.setCellRenderer(renderer);
	((UiTreeTableCellRenderer) renderer).setColumnAttribute(getColumnId());
	col.setCellEditor(table.getDefaultEditor(TreeModel.class));
}
/**
 * Need to repaint the table, but no direct access
 * to the table is available.
 */
protected void refreshTable() {
	if (getTreeRenderer() != null) {
		getTreeRenderer().setColumnAttribute(getColumnId());
		((UITreeTable) getTable()).updateAsync();
	}
}
/**
 * This method sets the column to be editable or not.
 * For a tree column, setEditable(false) only means that it
 * cannot be manually edited; it will *still* have to respond
 * to tree expand-collapse actions !
 */
public void setEditable(boolean editable) {
	//super.setEditable(editable);
	fIsEditable = editable;
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	super.setEnabled(state);
	getTreeCellRenderer().setEnabled(state);
}
/**
 * Answer boolean whether the receiver can be edited.
 * This special treatment of the treeColumn is required
 * because our treeColumn is always defined as editable
 * (i.e. isEditable() answers true). Else the treeTable 
 * will not get the tree expand-collapse events.
 * On the other hand, the above cannot be taken to imply that
 * the user is allowed to edit the tree column. So we use this
 * special method to check whether the user may edit the tree
 * column or not.
 */
public boolean ulcIsEditable() {
	return fIsEditable;
}
}
