package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import java.awt.event.FocusEvent;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.lists.IItemCacheListener;
public class UIRowModel extends UIStandardFormModel implements IEnableListener, IEnableListenerTarget, ISelectionListener, IItemCacheListener {
	protected int fRowId = -1;
	protected UiItemCache fCache = null;
	protected UIAbstractList fWidget = null;
	protected Vector fEmptyStateListeners = null;
	protected boolean fNotifiedUlcOfChanges = false;
	public UIRowModel() {
	}
/**
 * Add a component who will be notified when the state 
 * of the receiver changes.
 */
public void addEnableListener(IEnableListenerTarget component) {
	if (fEmptyStateListeners == null)
		fEmptyStateListeners = new Vector();
	fEmptyStateListeners.addElement(component);
	component.setEnabled(shouldEnableListener());
}
/**
 * Invalidate cell range.
 * Typically called from ULC via "change".
 */
void change(Anything args) {
	trouble("change", "rowmodel should never be updated from the ULC");
}
/**
 * Comments for the notifyCellsChanged method.
 * @param arg1 class [Lcom.ibm.ulc.ui.lists.IRow;
 * @param arg2 class [Ljava.lang.String;
 */
private boolean containsReceiversRow(com.ibm.ulc.ui.lists.IRow[] rows) {
	for (int i = 0; i < rows.length; i++) {
		if (rows[i].getOid() == fRowId)
			return true;
	}
	return false;
}
void enableListeners() {
	if (fEmptyStateListeners != null) {
		boolean state = shouldEnableListener();
		Enumeration e = fEmptyStateListeners.elements();
		while (e.hasMoreElements()) {
			IEnableListenerTarget c = (IEnableListenerTarget) e.nextElement();
			c.setEnabled(state);
		}
		if (state != fNotifiedUlcOfChanges) {
			fNotifiedUlcOfChanges = state;
			Anything a = new Anything();
			a.put("c", new Anything(state));
			sendOptionalEventULC("hasChanges", a);
		}
	}
}
public void focusLost(FocusEvent event) {
	if (fRowId > -1) {
		IRow row = getItemCache().getRow(fRowId);
		if (getItemCache().getModel().getNotificationPolicy() == FORM_NOTIFICATION_ON_FOCUS_CHANGE) {
			if (row != null) {
				if (row.hasUnsavedChanges())
					getItemCache().saveInput(-1, new IRow[] {row});
			}
		}
	}
}
protected UiItemCache getItemCache() {
	if (fCache == null) {
		if (fWidget == null)
			return null;
		else
			return fWidget.getItemList().getItemCache();
	}
	else
		return fCache;
}
/**
 * Returns an attribute value for the record in the column
 * with the unique identifier colId.
 *
 * @param colId		the attribute for which the receiver should answer the value
 */
public Object getValueAt(String attributeName) {
	Object answer = null;
	if (getItemCache() != null) {
		getItemCache().startRequest();
		answer = getItemCache().getValue(fRowId, attributeName);
		getItemCache().stopRequest();
	}
	return answer;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setRow")) {
		setRow(args.asInt(-1));
		return;
	}
	super.handleRequest(conn, request, args);
}
public void notify(int type, String key) {
	getItemCache().startRequest();
	super.notify(type, key);
	getItemCache().stopRequest();
}
/**
 * Comments for the notifyCellsChanged method.
 * @param arg1 class [Lcom.ibm.ulc.ui.lists.IRow;
 * @param arg2 class [Ljava.lang.String;
 */
public void notifyCellChanged(com.ibm.ulc.ui.lists.IRow row, String attributeName) {
	if (fRowId != -1 && row.getOid() == fRowId)
		notify(FORM_MODEL_CHANGED, attributeName);
}
/**
 * Comments for the notifyRowsChanged method.
 * @param arg class [Lcom.ibm.ulc.ui.lists.IRow;
 */
public void notifyRowsChanged(com.ibm.ulc.ui.lists.IRow[] rows) {
	if (containsReceiversRow(rows))
		notify(FORM_MODEL_CHANGED, null);
}
/**
 * Comments for the notifyRowsRemoved method.
 * @param arg class [Lcom.ibm.ulc.ui.lists.IRow;
 */
public void notifyRowsRemoved(com.ibm.ulc.ui.lists.IRow[] rows) {
	if (containsReceiversRow(rows)) {
		fRowId = -1;
		notify(FORM_MODEL_INVALID, null);
	}
}
/**
 * Comments for the notifyRowsRemoved method.
 * @param arg class [Lcom.ibm.ulc.ui.lists.IRow;
 */
public void notifyRowsSet(com.ibm.ulc.ui.lists.IRow[] rows) {
	if (containsReceiversRow(rows)) {
		notify(FORM_MODEL_CHANGED, null);
	}
}
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	if (fEmptyStateListeners == null)
		return;
	fEmptyStateListeners.removeElement(component);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	if (args.isDefined("w")) {
		fWidget = (UIAbstractList) getManaged(UIAbstractList.class, conn, args.get("w"));
		fWidget.addRowModel(this);
		DeferredRequest r = new DeferredRequest(conn) {
			public void safeDispatch() {
				fRowId = -2;
				updateSelection(fWidget.getSelectedRowIds());
			}
		};
		conn.postRequest(r);
	}
	else {
		UITableModel model = (UITableModel) getManaged(UITableModel.class, conn, args.get("tableModel"));
		setItemCache(model);
		final int row = args.get("row", -1);
		if (row != -1) {
			DeferredRequest r = new DeferredRequest(conn) {
				public void safeDispatch() {
					setRow(row);
				}
			};
			conn.postRequest(r);
		}
	}
}
public void setEnabled(boolean enabled) {
	enableListeners();
}
private void setItemCache(UITableModel model) {
	if (getItemCache() != null) {
		UITableModel m = getItemCache().getModel();
		if (m != null)
			m.removeEnableListener(this);
		getItemCache().removeListener(this);
	}
	if (model == null)
		fCache = null;
	else
		fCache = model.getItemCache();
	if (getItemCache() != null) {
		getItemCache().addListener(this);
		getItemCache().getModel().addEnableListener(this);
	}
}
void setRow(int rowId) {
	if (rowId != fRowId) {
		fRowId = rowId;
		getItemCache().startRequest();
		notify(fRowId == -1 ? FORM_MODEL_INVALID : FORM_MODEL_CHANGED, null);
		getItemCache().stopRequest();
	}
}
/**
 * Change the value of attribute <code>colId</code> to <code>value</code>. This message
 * is passed to the receiver's tableModel because the receiver does not hold the current
 * model's state.
 */
public void setValueAt(Object value, String attributeName, IFormModelListener sender, int notificationPolicy) {
	if (fRowId > -1) {
		getItemCache().setValue(fRowId, attributeName, value, this, getItemCache().getModel().getNotificationPolicy());
		enableListeners();
		notify(FORM_MODEL_CHANGED, attributeName, sender);
	}
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 *
 */
public boolean shouldEnableListener() {
	return getItemCache().getRow(fRowId).hasUnsavedChanges();
}
/*
 * the selection of the receiver's widget has changed. Set the reciever's current row to the
 * last item in the widget's current selection, or to -1, if the widget does not have any selection
 *
 * @param selectedIndices		the array of selected indices of the widget
 */
public void updateSelection(int[] selectedRowIds) {
	IRow[] rows = new IRow[selectedRowIds.length];
	for (int i = 0; i < selectedRowIds.length; i++) {
		rows[i] = getItemCache().getRow(selectedRowIds[i]);
	}
	updateSelection(rows);
}
/*
 * the selection of the receiver's widget has changed. Set the reciever's current row to the
 * last item in the widget's current selection, or to -1, if the widget does not have any selection
 *
 * @param selectedIndices		the array of selected indices of the widget
 */
public void updateSelection(IRow[] selectedRows) {
	IRow selectedRow = UiInvalidRow.getInstance();
	if (selectedRows.length > 0) {
		selectedRow = selectedRows[selectedRows.length - 1];
	}
	if (fRowId != selectedRow.getOid()) {
		fRowId = selectedRow.getOid();
		notify(fRowId == -1 ? FORM_MODEL_INVALID : FORM_MODEL_CHANGED, null);
	}
}
}
