package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.Assert;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.ui.*;
public class UIList extends UIAbstractList {
	protected UiListModelWrapper fListModel = null;
public void free() {
	if (fListModel != null) {
		fListModel.free();
		fListModel = null;
	}
	super.free();
}
protected void setComponent(ORBConnection conn, Anything args) {
	fListModel = new UiListModelWrapper(fItemList, args.get("colId", "???"));
	fWidget = (IJList) new UiJList(fListModel, this);
	JList widget = (JList) fWidget;
	widget.setPrototypeCellValue("Index 1234567890");
	widget.addMouseListener(this);
	UIComponent renderer = (UIComponent) getManaged(UIComponent.class, conn, args.get("renderer"));
	String colId = args.get("colId", "null");
	if (renderer == null)
		renderer = new UILabel();
	widget.setCellRenderer(new UiListCellRenderer(renderer.getComponent(), colId));
}
protected void setDimensions(Anything args) {
	int rowHeight = args.get("rowHeight", -1);
	if (rowHeight == -1)
		rowHeight = getDefaultRowHeight();
	getWidget().setRowHeight(rowHeight);
	int rowsVisible = args.get("rows", 10);
	getWidget().setVisibleRowCount(rowsVisible + 1);
	int height = getWidget().getPreferredHeight();
	Dimension size = new Dimension(0, 0);
	size.height = args.get("h", height);
	size.width = args.get("w", 100);
	fScrollPane = new UiJScrollPane((JList) getWidget());
	fScrollPane.setPreferredSize(size);
	fScrollPane.setBorder(new BevelBorder(BevelBorder.LOWERED));
}
protected void setItemList(ORBConnection conn, Anything args) {
	super.setItemList(conn, args, false);
	if (fListModel != null)
		fListModel.setItemList(fItemList);
}
protected void setItemList(ORBConnection conn, Anything args, boolean notify) {
	super.setItemList(conn, args, notify);
	if (fListModel != null)
		fListModel.setItemList(fItemList);
}
}
