package com.ibm.ulc.ui.dataTypes;

/**
 * Insert the type's description here.
 * Creation date: (23-Nov-99 12:41:57 PM)
 * @author: Markus Marzetta (CS-ZRH)
 */
public class UIIntegerNumberFormatConverter extends UINumberFormatConverter {
/**
 * UIIntegerNumberFormatConverter constructor comment.
 */
public UIIntegerNumberFormatConverter() {
	super();
}
/**
 * convertToObject using NumberFormat
 *
 * If the numberformat does not answer a Long or Double,
 * as promised in the comment of 
 *   NumberFormat :: Number parse(String, ParsePosition),
 * throw an exception. 
 * Do the same if the value is too big.
 * Otherwise, cast the result into an Integer.
 */
 
public Object convertToObject(String string) throws DataTypeConversionException {
	Object object = super.convertToObject(string);
	Long lobj = null;

	if (object instanceof Long) {
		lobj = (Long) object;
	} else if (object instanceof Double) {
		lobj = new Long(((Double) object).longValue());
	} else {
		throw new DataTypeConversionException("Could not be converted to Long or Double");
	}

	long lValue = lobj.longValue();
	if (lValue < Integer.MIN_VALUE || Integer.MAX_VALUE < lValue) {
		throw new DataTypeConversionException("Integer overflow");
	}
	return new Integer(lobj.intValue());
}
}
