package com.ibm.ulc.ui.dataTypes;

import com.ibm.ulc.ui.UIProxy;
/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This class defines validators that can be associated with text
 * fields. They allow for input validation &/or formatting to be
 * performed locally, without the need to make a round-trip
 * to the application and back.
 *
 * This class is intended to be subclassed in order to do specific validation
 * &/or formatting operations, by implementing the protocol specified
 * by the IDataType interface.
 */
import javax.swing.text.AttributeSet;
public class UIDataType extends UIProxy implements IDataType {
/**
 * Default constructor for the receiver
 */
public UIDataType() {
}
/**
 * The default implementation returns the fields string as an object.
 * Subclasses should override this method to return the configured data type.
 *
 * @param phase int	The current validation phase.
 * The phase can be one of the following:
 * <pre>
 *	FORM_NOTIFICATION_IMMEDIATE : Typically no validation is performed in this case the input string is returned as is.
 *	FORM_NOTIFICATION_ON_FOCUS_CHANGE 	 
 * 	FORM_NOTIFICATION_ON_REQUEST
 *	</pre>
 * @param newString The String to convert.
 * @return An object representing the converted String or null.
 *
 * @see IDataType#convertToObject(int, String, Object)
 */
public Object convertToObject(int phase, String newString, Object previousValue) throws DataTypeConversionException {
	return newString;
}
/**
 * Return the String represenation of the object or the empty string if object is null.
 * The default implementation calls the toString() to return a string representation of the object.
 * Subclasses should override this method to return the formatted data type as a String.
 *
 * @see IDataType#convertToString(Object, boolean)
 */
public String convertToString(Object object, boolean forEditing) {
	if (object != null)
		return object.toString();
	return "";
}
/**
 * Hook to filter any text input into the field.
 *
 * @param position		The location where the input is being inserted 
 * @param newString 	The string to filter.
 * @param currentText 	The current Contents.
 * @param attribute		The attributes of the text being inserted
 *
 * @return the filtered result, If null input is not accepted.
 * @see IDataType#filterInput(String, String)
 */
public String filterInput(int position, String newString, String currentText, AttributeSet attribute) {
	return filterInput(newString, currentText);
}
/**
 * The default implementation returns original string without modification.
 *
 * @see IDataType#filterInput(String)
 */
public String filterInput(String newString) {
	return newString;
}
/**
 * Hook to filter any text input into the field.
 *
 * @param newString The string to filter.
 * @param currentText The current Contents.
 *
 * @return the filtered result, If null input is not accepted.
 * @see IDataType#filterInput(String, String)
 */
public String filterInput(String newString, String currentText) {
	return filterInput(newString);
}
/**
 * Returns the default width (in characters) used to determine the size of a field
 * or table and list column of this DataType. Can be overidden by giving the field an
 * explicit size.
 */
public int getCols() {
	return 10;
}
/**
 * Returns the default object to be returned when a data conversion error occurs.
 */
public Object getDefaultValue(String newString) {
	return null;
}
}
