package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;

public abstract
class UiLayoutManager implements LayoutManager {

	abstract public Dimension layoutSize(Container parent, boolean minimum);
 	public Dimension minimumLayoutSize(Container parent) {
 		return layoutSize(parent, true);
 	}  
 	public void positionInCell(String attr, Component c, int x, int y, int cellw, int cellh) {
		Dimension d= c.getPreferredSize();

		switch (attr.charAt(0)) {
		case 'e':
		case 'f':
			d.width= cellw;
			break;
		case 'l':
			break;
		case 'c':
			x+= (cellw - d.width) / 2;
			break;
		case 'r':
			x+= (cellw - d.width);
			break;
		}
		switch (attr.charAt(1)) {
		case 'e':
		case 'f':
			d.height= cellh;
			break;
		case 't':
			break;
		case 'B':
			y+= (cellh - d.height) / 2;
			break;
		case 'c':
			y+= (cellh - d.height) / 2;
			break;
		case 'b':
			y+= (cellh - d.height);
			break;
		}
		c.setBounds(x, y, d.width, d.height);
 	}  
 	public Dimension preferredLayoutSize(Container parent) {
 		return layoutSize(parent, false);
 	}  
}
