package com.ibm.ulc.testsample;

import java.util.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.test.UlxPerson;
import com.ibm.ulc.test.UlxAddress;
import com.ibm.ulc.test.cases.UlxSimplePerson;
//
public class UlxData {
	protected UlxSimplePerson fFounder;
	protected Vector fPersons;
	//
	static Random fRandom = new Random();
	static int DATA_NONE = 0;
	static int DATA_SMALL = 1;
	static int DATA_NORMAL = 2;
	static int DATA_LARGE = 3;
	static int DATA_HUGE = 4;
	static int DATA_GIGANTIC = 5;
	static int[] SCOPE_TRANSLATION = new int[] {0, 10, 100, 500, 5000, 200000,};
	static String[] SCOPE_NAMES = new String[] {"None", "Small", "Standard", "Large", "Huge", "Gigantic"};
	int fScope = DATA_NORMAL;
public UlxData() {
	initialize();
}
/**
 * 
 * @param scope int
 */
public UlxData(int scope) {
	this();
	fScope = scope;
}
public void createTreeData() {
	UlxSimplePerson granddaddy = new UlxSimplePerson("Frank", "Smith", UlxSimplePerson.fgLastFieldIdentifier++, null);
	fPersons.add(granddaddy); //The 'root' of the person hierarchy
	UlxSimplePerson daddy = newPerson("Frank jun.", "Smith", granddaddy);
	fPersons.add(daddy);
	newPerson("William", "Smith", daddy);
	newPerson("Elisabeth", "Smith", daddy);
	newPerson("Victor", "Smith", daddy);
	newPerson("Thurmond.", "Smith", granddaddy);
	newPerson("Rachel", "Jones", granddaddy);
	newPerson("Ruth", "Jones", daddy);
	newPerson("Elisabeth", "Miller", daddy);
	newPerson("Barnabas", "Jones", daddy);
}
/**
 * Delete the given person from it's parent.
 * And also from the receiver's list of all persons.
 */
public void deletePerson(UlxSimplePerson person) {
	UlxSimplePerson parent = person.getParent();
	if (parent != null)
		parent.deleteChild(person);
	else { //The root is being deleted. Empty out everything.
		fFounder = null;
		fPersons = new Vector();
	}
	fPersons.remove(person);
}
/**
 * Delete the given persons.
 */
public void deletePersons(Vector persons) {
	Vector clonePersons = (Vector) persons.clone();
	for (int i = 0; i < clonePersons.size(); i++) {
		UlxSimplePerson person = (UlxSimplePerson) clonePersons.get(i);
		deletePerson(person);
	}
}
public UlxSimplePerson getCoFounder() {
	return (UlxSimplePerson) getFounder().getChildren().elementAt(0);
}
public UlxSimplePerson getFounder() {
	if (fFounder == null)
		if (!fPersons.isEmpty())
			fFounder = (UlxSimplePerson) fPersons.elementAt(0);
	return fFounder;
}
public int getNumberOfPersons() {
	return fPersons.size();
}
public UlxSimplePerson getPersonAt(int row) {
	return (UlxSimplePerson) fPersons.elementAt(row);
}
public int getScope() {
	return fScope;
}
protected void initialize() {
	fPersons = new Vector();
	createTreeData();
}
/**
 * Create and answer a new person.
 * Note that this also results in adding the new person to it's parent.
 */
public UlxSimplePerson newPerson(String firstName, String lastName, UlxSimplePerson parent) {
	return newPerson(firstName, lastName, parent, -1);
}
/**
 * Create and answer a new person.
 * Remember that this also results in adding the new person to it's parent.
 * In addition, we add the new person to the receivers list of all persons.
 */
public UlxSimplePerson newPerson(String firstName, String lastName, UlxSimplePerson parent, int childIndex) {
	UlxSimplePerson newPerson = new UlxSimplePerson(firstName, lastName, parent, childIndex);
	fPersons.add(newPerson);
	return newPerson;
}
/**
 * Add multiple persons of the given name. For this, append an integer to the given name.
 * Use the childIndex as the position to start inserting at.
 */
public UlxSimplePerson[] newPersons(String firstName, String lastName, UlxSimplePerson parent, int childIndex, int howMany) {
	UlxSimplePerson[] newPersons = new UlxSimplePerson[howMany];
	for (int i = 0; i < howMany; i++) {
		UlxSimplePerson newPerson = newPerson(firstName + i, lastName + i, parent, childIndex++); //incremented the index for next guy.
		newPersons[i] = newPerson;
	}
	return newPersons;
}
Date randomBirthDate() {
	return randomDate(1900, 78);
}
Date randomDate() {
	return randomDate(1900, 150);
}
Date randomDate(int minYear, int maxYear) {
	java.util.Calendar c = new java.util.GregorianCalendar();
	c.set(minYear + randomInt(maxYear), Math.max(1, randomInt(12)), Math.max(1, (randomInt(28))));
	return c.getTime();
}
synchronized float randomFloat(int multiplier) {
	return fRandom.nextFloat() * multiplier;
}
void randomInitialize(int identifier, UlxAddress address) {
	address.setCity(randomString(20, 6));
	address.setCountry(randomString(10, 3));
	address.setState(randomString(10, 3));
	address.setStreet(randomString(15, 5));
	address.setZipCode(randomInteger(9999, 1000).toString());
}
void randomInitialize(int identifier, UlxPerson person) {
	person.setBirthdate(randomBirthDate());
	person.setFirstName(randomString(20, 5));
	//person.setHomeAddress((UlxAddress) getAddresses()[Math.max(0, randomInt(translateScopeToNumber()) - 1)]);
	person.setLastName(randomString(21, 4));
	person.setEmailAddress(person.getFirstName() + "_" + person.getLastName() + "@" + randomString(15, 3) + ".com");
	person.setNumberOfChildren(randomInt(9, 0));
	person.setPersonNumber(identifier);
	person.setPhoneNumber("(00" + randomInteger(999, 1).toString() + ") " + randomInteger(100, 1).toString() + "-" + randomInteger(999999, 10000).toString());
	person.setSpeaksForeignLanguages(identifier / 2 == 0);
	person.setXq(randomFloat(100));
}
synchronized int randomInt(int maxValue) {
	return Math.round(fRandom.nextFloat() * maxValue);
}
synchronized int randomInt(int maxValue, int minValue) {
	return Math.max(randomInt(maxValue), minValue);
}
synchronized Integer randomInteger(int maxValue, int minValue) {
	return new Integer(randomInt(maxValue, minValue));
}
String randomString() {
	return randomString(randomInt(20), 5);
}
String randomString(int maxLength) {
	return randomString(maxLength, 0);
}
String randomString(int maxLength, int minLength) {
	if (maxLength < minLength)
		return randomString(minLength, minLength);
	if (maxLength == 0)
		return "";
	char[] chars = new char[] {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
	int length = randomInt(maxLength, minLength);
	char[] c = new char[length];
	c[0] = Character.toUpperCase(chars[Math.max(randomInt(26) - 1, 0)]);
	for (int i = 1; i < length; i++)
		c[i] = chars[Math.max(randomInt(26) - 1, 0)];
	return new String(c);
}
void setScope(int scope) {
	if (scope >= DATA_NONE && scope <= DATA_GIGANTIC) {
		if (fScope != scope) {
			int oldScope = fScope;
			fScope = scope;
			/*if (fAddresses != null)
				updateAddressTableModel(oldScope);
			if (fPersons != null)
				updatePersonTableModel(oldScope);*///LATER
		}
	}
}
int translateScopeToNumber() {
	return SCOPE_TRANSLATION[getScope()];
}
}
