package com.ibm.ulc.test;

import java.util.Vector;
import java.util.Enumeration;
import com.ibm.ulc.application.GenericTableModel;
import com.ibm.ulc.util.ITableRow;
public class UlxTableModel extends GenericTableModel implements IUlxModelOwner {
/**
 * Create an instance of the receiver.
 */
public UlxTableModel() {
	super();
}
/**
 * Create an instance of the receiver.
 */
public UlxTableModel(IUlxModel[] models) {
	this();
	setRows(UlxCollection.copyToVector(models));
}
/**
 * add a vector of rows at the end of the receiver's data.
 * Notify the UI that my contents have changed.
 */
public void addRows(Vector vector) {
	int index = getRowCount();
	Enumeration e = vector.elements();
	while (e.hasMoreElements()) {
		addRow((ITableRow) e.nextElement(), false);
	}
	notifyRowsAdded(index, index + vector.size());
}
/**
 * Override this method to return the requested row.
 *
 * @param row	The index of the row being accessed.
 */
public IUlxModel getModelAt(int index) {
	if (index >= 0 && index < getRowCount())
		return (IUlxModel) getRowAt(index);
	else
		return null;
}
/**
 * Override this method to return the requested value for the specified cell.
 *
 * @param attributeName	The key of the attribute to be retrieved.
 * @param row			The index of the row being accessed.
 */
public Object getValueAt(String attributeName, int index) {
	return getModelAt(index).getValueAt(attributeName);
}
/**
 * the receiver's defaultItemList has mapped @index to an oid. Default is to ignore this message.
 */
protected void indexWasMapped(int index) {
	getModelAt(index).setIdentifier(this, getItemList().getOidForIndex(index));
}
/**
 * This method gets called when a bound property is changed.
 * @param evt A PropertyChangeEvent object describing the event source 
 *   	and the property that has changed.
 */

public void modelChanged(IUlxModel model, String attributeName) {
	if (model.isMapped(this)) {
		notifyCellChanged(attributeName, getItemList().getIndexForOid(model.getIdentifier(this)));
	}
}
/**
 * Remove the row at the specified row index and notify the UI if notify is true.
 */
public void removeRowAt(int rowIndex, boolean notify) {
	UlxModel model = (UlxModel) getRows().elementAt(rowIndex);
	super.removeRowAt(rowIndex, notify);
	model.resetOwner(this);
}
/**
 * Set the contents of attributeName at the specified rowIndex to be the specified value.
 * Notify the UI that the cell has changed.
 */
public void setValueAt(Object value, String attributeName, int rowIndex) {
	IUlxModel model = (IUlxModel) getRows().elementAt(rowIndex);
	if (model != null)
		model.setValueAt(value, attributeName);
}
}
