package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.application.*;
import java.util.Vector;
import com.ibm.ulc.examples.carRental.model.FinalPersistentObject;

/**
 * A table model for FinalPersistentObjects.
 * @author: Markus Marzetta (CS-ZRH)
 */

public class FinalPersistentTableModel extends ULCTableModel {
	/**
	 * the rows
	 * @serial
	 */
	 protected FinalPersistentObject[] fFinalObjects= null;
/**
 * FinalPersistentTableModel constructor comment.
 */
public FinalPersistentTableModel() {
	super();
}
/**
 * FinalPersistentTableModel constructor comment.
 * @param prefetch int
 */
public FinalPersistentTableModel(int prefetch) {
	super(prefetch);
}
/**
 * FinalPersistentTableModel constructor comment.
 * @param prefetch int
 * @param policy int
 */
public FinalPersistentTableModel(int prefetch, int policy) {
	super(prefetch, policy);
}
/**
 * FinalPersistentTableModel constructor comment.
 * @param prefetch int
 * @param veto boolean
 * @param policy int
 */
public FinalPersistentTableModel(int prefetch, boolean veto, int policy) {
	super(prefetch, veto, policy);
}
/**
 * FinalPersistentTableModel constructor comment.
 * @param veto boolean
 */
public FinalPersistentTableModel(boolean veto) {
	super(veto);
}
/**
 * FinalPersistentTableModel constructor comment.
 * @param veto boolean
 * @param policy int
 */
public FinalPersistentTableModel(boolean veto, int policy) {
	super(veto, policy);
}
/**
 * getRowAt method comment.
 */
public Object getRowAt(int row) {
	return fFinalObjects[row];
}
/**
 * getRowCount method comment.
 */
public int getRowCount() {
	return fFinalObjects==null ? 0 : fFinalObjects.length;
}
/**
 * getValueAt should not be used any more.
 */
public Object getValueAt(String attributeName, int rowIndex) {
	FinalPersistentObject finObj= fFinalObjects[rowIndex];
	if (attributeName.equals("id"))
		return finObj.getId();
	if (attributeName.equals("name"))
		return finObj.getName();
	return null;
}
/**
 * Set the rows of the model.
 * Creation date: (06.01.00 17:36:33)
 * @param finalPersistentObjects com.ibm.ulc.examples.carRental.model.FinalPersistentObject[]
 */
public void setRows(FinalPersistentObject[] finalPersistentObjects) {
	fFinalObjects= finalPersistentObjects;
}
}
