package com.ibm.ulc.examples.carRental.model;

import java.util.Date;

/**
 * Instances hold a reference to a contract spec and compute its price.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class Pricer extends CarRentalObject {
	/**
	 * The owning contract spec.
	 */
	 protected ContractSpec fContract= null;
/**
 * Pricer constructor comment.
 */
public Pricer() {
	super();
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (27.12.99 13:42:29)
 * @param contract com.ibm.ulc.examples.carRental.model.ContractSpec
 */
public Pricer(ContractSpec contract) {
	fContract= contract;
}
/**
 * Gets the contract property (com.ibm.ulc.examples.carRental.model.ContractSpec) value.
 * @return The contract property value.
 * @see #setContract
 */
public ContractSpec getContract() {
	return fContract;
}
/**
 * Answer the price of the contract.
 * 
 * Creation date: (27.12.99 13:46:13)
 * @return double
 */
public double getPrice() {
	Date stopD= fContract.getReturnDetails().getDate();
	if (stopD==null) return -1.0;
	long stop= stopD.getTime();

	Date startD= fContract.getPickupDetails().getDate();
	if (startD==null) return -1.0;
	long start= startD.getTime();
	
	long days= ((stop-start) / 86400000) + 1;
	long weeks= days / 7;
	long remDays= days - (7*weeks);
	return (weeks*getPricePerWeek())+(remDays*getPricePerDay());
}
/**
 * Answer the price of the contract per day.
 * 
 * Creation date: (27.12.99 13:46:13)
 * @return double
 */
public double getPricePerDay() {
	return 50.0;
}
/**
 * Answer the price of the contract per week.
 * 
 * Creation date: (27.12.99 13:46:13)
 * @return double
 */
public double getPricePerWeek() {
	return 250.0;
}
/**
 * Sets the contract property (com.ibm.ulc.examples.carRental.model.ContractSpec) value.
 * @param contract The new value for the property.
 * @see #getContract
 */
public void setContract(ContractSpec contract) {
	fContract = contract;
}
}
