package com.ibm.ulc.examples.carRental.model;

/**
 * The information about the customer.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class CustomerSpec extends CarRentalObject {
	/**
	 * The customer's country of residence
	 */
	protected Country fResidenceCountry = null;

	/**
	 * The rate scheme applicable for the customer.
	 */
	protected RateScheme fRateScheme = null;

	/**
	 * The customer ID
	 */
	protected String fCustomerId = "";
/**
 * CustomerSpec constructor comment.
 */
public CustomerSpec() {
	super();
}
/**
 * Gets the customerId property (String) value.
 * @return The customerId property value.
 * @see #setCustomerId
 */
public String getCustomerId() {
	return fCustomerId;
}
/**
 * Gets the rateScheme property (com.ibm.ulc.examples.carRental.model.RateScheme) value.
 * @return The rateScheme property value.
 * @see #setRateScheme
 */
public RateScheme getRateScheme() {
	return fRateScheme;
}
/**
 * Gets the RateScheme's name.
 */
public String getRateSchemeName() {
	return fRateScheme==null ? "" : fRateScheme.getName();
}
/**
 * Gets the residenceCountry property (com.ibm.ulc.examples.carRental.model.Country) value.
 * @return The residenceCountry property value.
 * @see #setResidenceCountry
 */
public Country getResidenceCountry() {
	return fResidenceCountry;
}
/**
 * Gets the residenceCountry's name.
 */
public String getResidenceCountryName() {
	return fResidenceCountry==null ? "" : fResidenceCountry.getName();
}
/**
 * Sets the customerId property (String) value.
 * @param customerId The new value for the property.
 * @see #getCustomerId
 */
public void setCustomerId(String customerId) {
	fCustomerId = customerId;
}
/**
 * Sets the rateScheme property (com.ibm.ulc.examples.carRental.model.RateScheme) value.
 * @param rateScheme The new value for the property.
 * @see #getRateScheme
 */
public void setRateScheme(RateScheme rateScheme) {
	fRateScheme = rateScheme;
}
/**
 * Sets the rateScheme to the rate scheme having name rateScheme.
 */
public void setRateSchemeName(String rateScheme) {
	fRateScheme= DataAccessor.instance().rateSchemeNamed(rateScheme);
}
/**
 * Sets the residenceCountry property (com.ibm.ulc.examples.carRental.model.Country) value.
 * @param residenceCountry The new value for the property.
 * @see #getResidenceCountry
 */
public void setResidenceCountry(Country residenceCountry) {
	fResidenceCountry = residenceCountry;
}
}
