package com.ibm.ulc.examples.ManagementStructure;

import com.ibm.ulc.application.*;

/**
 * This class handles the events which occur when various operations
 * are performed on the tree widget.
 *
 * Note: It is also possible to implement just the events necessary
 * for the receiver without implementing all the stubs - this can be
 * done by inheriting from the DefaultTreeListener class.
 *
 * @see DefaultTreeListener 
 */

 
class TreeNodeAction extends ManagementStructureAction implements ITreeListener {
public TreeNodeAction(ManagementStructureEditor editor) {
	super(editor);
}
/**
 * Pass this information back to the editor, so
 * that it can do the needful.
 */
public void treeActionPerformed(ULCTreeEvent e) {
	fEditor.performDefaultActionFor(e.getSelectedNode(), e.getSelectedNodes());
}
/**
 * Pass this information back to the editor, so
 * that it can do the needful.
 */
public void treeCollapsed(ULCTreeEvent e) {
	fEditor.performCollapseActionFor(e.getSelectedNode());
}
/**
 * Pass this information back to the editor, so
 * that it can do the needful.
 */
public void treeExpanded(ULCTreeEvent e) {
	fEditor.performExpandActionFor(e.getSelectedNode());
}
/**
 * Pass this information back to the editor, so
 * that it can do the needful.
 * Note: In this implementation, we don't specifically
 * check for single or muti-selection. In case of multi-
 * selection, therefore, the first node in the list is
 * taken as the 'selected node'.
 */
public void treeSelected(ULCTreeEvent e) {
	fEditor.setEmployeeSelection(e.getSelectedNode());
	fEditor.displaySelectedNodes(e.getSelectedNodes());	
}
}
