package com.ibm.ulc.examples.ManagementStructure;

import java.util.*;
import com.ibm.ulc.application.*;

/**
 * This is the adapter class which adapts the tree view of the organization,
 * to the organizational model provided by the application. This is done by 
 * extending the ULCTreeModel, which is the basic adapter for the ULCTree
 * widget. The ULCTreeModel provides an abstract API, which needs to be
 * implemented by this receiver.
 *
 * @see ULCTreeModel
 */
public class ManagementStructureAdapter extends ULCTreeModel {

	/**
	 * The model for the management structure of the organization
	 */
	protected ManagementStructureModel fHierarchy;
	
	/**
	 * The CEO of the company
	 */
	protected Employee fBiggestBoss;

	/** 
	 * A reference to the editor being used for the display,
	 * in order to be able to update the status of the
	 * application when specific events occur.
	 */
	protected ManagementStructureEditor fEditor;
public ManagementStructureAdapter() {
	fHierarchy= ManagementStructureModel.createTestModel();
	fBiggestBoss= fHierarchy.getCEO();
}
public ManagementStructureAdapter(ManagementStructureEditor editor) {
	this();
	fEditor= editor;
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the number of children for the given object.
 *
 * @param userObject	: 	The object being represented as a node
 *							in the tree.
 */
public int getChildCount(Object userObject) {
	return ((Employee) userObject).getChildCount();
}
/**
 * Override this method to return the index of the given child object,
 * in the given parent bject. 
 * This method is (only) required in case operations (e.g. setSelection) 
 * are being performed on a node which has not yet been uploaded to the
 * UI side.
 *
 * By default, the child will be assumed to be the first child of this parent.
 *
 * @param parent The domain object containing the given child.
 * @param child	The domain object whose parent is required.
 */
public int getChildIndexFor(Object child, Object parent) {
	return getChildren(parent).indexOf(child);
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the children for the given object.
 *
 * @param parent	: 	The object being represented as a node
 *						in the tree.
 */
public Vector getChildren(Object parent) {
	return ((Employee) parent).getChildren();
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the icon to be used for representing the given object
 * in the tree.
 *
 * @param userObject	: 	The object being represented as a node
 *							in the tree.
 */
public ULCIcon getIcon(Object userObject) {
	// Note that this implementation avoids the employee
 	// (business object) having to import the ULCIcon class.
	return new ULCIcon(getClass().getResource(
		((Employee) userObject).getIconName()));
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the label to be used for representing the given object
 * in the tree.
 *
 * @param userObject	: 	The object being represented as a node
 *							in the tree.
 */
public String getLabel(Object userObject) {
	return ((Employee) userObject).getLabel();
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the parent for the given object.
 *
 * @param child	: 	The object being represented as a node
 *						in the tree.
 */
public Object getParent(Object child) {
	return ((Employee) child).getParent();
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the root (node) of the management structure
 * tree
 */
public Object getRoot() {
	return fBiggestBoss;
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the value of the specified attribute of the given object
 * in the tree.
 *
 * @param columnId		: 	The columnIdentifier for a column in the tree,
 * 							which typically represents one attribute of this
 *							userObject.
 *
 * @param userObject	: 	The object being represented as a node
 *							in the tree.
 */
public Object getValueAt(String columnId, Object userObject) {
	if (columnId.equals("numOfReports"))
		return new Integer(((Employee) userObject).getChildCount());
	if (columnId.equals("hasReports"))
		return new Boolean(((Employee) userObject).getChildCount() > 0);
	if (columnId.equals("BossName"))
		return ((Employee) userObject).getBossName();
	if (columnId.equals("PreloadedAttribute"))
		return "Preloaded for: " + ((Employee) userObject).getName();
	return columnId; // Useful for testing random column-addition
}
/**
 * Set the given employee as the new CEO of the
 * company.
 */
protected void setNewCEO(Employee anEmployee) {
	fBiggestBoss= anEmployee;
}
}
