package com.ibm.ulc.examples.Dossier;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.*;
import java.io.*;
import java.net.*;

public class Customers extends ULCTableModel {
	private Anything fData;
	private URL fURL;
Customers() {
	super(false); // no veto
	fData = new Anything();
}
Customers(URL url) {
	super(false); // no veto
	fURL = url;
	if (fURL != null) {
		try {
			fData = Anything.read(fURL.openStream());
		} catch (java.io.IOException e) {
			fData = null;
		}
	}
	if (fData == null)
		fData = new Anything();
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
	int add(Customer c) {
		fData.append(c.getAnything());
		int x= fData.size()-1;
		notify(TABLE_MODEL_ROWS_ADDED, null, x, x);
		return x;
	}
int addAtIndex(Customer c, int index) {
	Anything newData = new Anything();
	int size = fData.size();
	for (int i = 0;((i < index) && (size > i)); i++) {
		newData.append(fData.get(i));
	}
	newData.append(c.getAnything());
	for (int i = index;(i < size); i++) {
		newData.append(fData.get(i));
	}
	fData = newData;
	notify(TABLE_MODEL_ROWS_ADDED, null, index, index);
	return index;
}
	void changeAt(int x) {
		notify(TABLE_MODEL_ROWS_CHANGED, null, x, x);
	}
void changeAt(int x, String colId) {
	notify(TABLE_MODEL_CELL_CHANGED, colId, x, x);
	if ((colId != null) && (colId.equals("Member")))
		changeAt(x, "Icon");
}
	void delete(int x) {
		fData.remove(x);
		notify(TABLE_MODEL_ROWS_REMOVED, null, x, x);
	}
	public int findIndexOf(String pattern) {
		String p= pattern.toUpperCase();
		for (int i= 0; i < getRowCount(); i++)
			if (get(i).matches(p))
				return i;
		return -1;
	}
	Customer get(int x) {
		Anything a= fData.get(x);
		if (a != null)
			return new Customer(a);
		return null;
	}
public Object getRowAt(int row) {
	Customer c = get(row);
	if (c != null) {
	//	Dossier dossier = (Dossier) getContext();
		return c;
	}
	return "?";
}
public int getRowCount() {
	if (fData == null)
		return 0;
	else
		return fData.size();
}
	public Object getValueAt(String colId, int x) {
		Customer c= get(x);
		if (c != null) {
			Dossier dossier= (Dossier) getContext();
	  		return c.get(colId, dossier);
		}
		return "?";
	}
	void save() {
			// HACK: we can't write to the URL connection (the protocol doesn't support it)
			// so we have to extract the file name from the URL.
			// It is not clear whether this is portable.
			String name= fURL.getFile();
			String prefix= "/FILE";
		 	if (name.startsWith(prefix)) {
		 		name= name.substring(prefix.length(), name.length());
		 		int p= name.lastIndexOf("/+/");
		 		if (p != -1) {
		 			String suffix= name.substring(p+3, name.length());
		 			name= name.substring(0, p).concat(File.separator);
		 			name= name.concat(suffix);
		 		}	
		   }	
			fData.write(name);
	}
	public void setValueAt(Object v, String colId, int x) {
		Customer c= get(x);
		if (c != null) {
			c.put(colId, v);
			if (colId.equals("Member")) changeAt(x, "Icon");
		}

	}
}
