package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.*;

/**
 * This class is used for acting on the callbacks that
 * occur, when one account is selected from the list of
 * accounts in the accountsTable (in the Notebook).
 * 
 * @see CustomerInformationEditor#buildAccountsTable
 */
class SelectAccountAction extends CustomerInformationAction implements ISelectionChangedListener {

public SelectAccountAction(CustomerInformationEditor editor) {
	super (editor);
}
/**
 * From the callback, get the row index selected.
 * Pass this information back to the builder, so
 * that it can do the needful.
 */
public void selectionChanged(ULCSelectionChangedEvent e) {
	fEditor.setAccountSelection(e.getFirstIndex());
}
}
