package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.application.*;

/**
 * This class is intended to adapt the credit to
 * the requirements of being placed on a ULC Form,
 * i.e. of adhering to the ULCFormModel interface.
 */
public class CreditAdapter extends ULCFormModel {
	protected Credit fCredit;
/**
 * By default, no credit is selected (when this receiver is
 * being created. Hence a dummy instance is created, which makes
 * it easier for the user to modify...
 */

public CreditAdapter () {
	setNewDummyCredit();
}
/**
 * This is the abstract method in the superclass, which needs to be
 * over-ridden. 
 *
 * Therefore need to do the necessary processing to answer the corresponding
 * value from the 'real' model. 
 *
 * @param key 	is the identifier for an attribute in the receiver. So this
 *					would have a value (say) "Number", "Type" etc.						
 */
 
public Object getValueAt(String key) {
	if (fCredit != null) {
		Object value= fCredit.getValueForAttributeName(key);
		if (value == null) return "";
		else return value;
	}	
	else return "";
}
/** 
 * Check that there is indeed a different credit selected. 
 * If not, we should not send any updates, events etc.
 */
void setCredit(Credit newCredit) {
	if (newCredit != fCredit) {
		fCredit= newCredit;
		notify(FORM_MODEL_CHANGED, null);
	}	
}
void setCreditForAccount(Account newlySelectedAccount) {
	Credit credit= null;
	try {
		credit= (Credit) newlySelectedAccount.getCredits().firstElement();
		setCredit(credit);
	}
	catch (NoSuchElementException e) {
		// This means that there are no credits allocated on this
		// account. No problem, do nothing.
	}	
}
/**
 * By default, no credit is selected (when this receiver is
 * being created. Hence a dummy instance is created, which makes
 * it easier for the user to modify...
 */
 
public void setNewDummyCredit() {
	setCredit(Credit.createInitialDummyCredit());
}
}
