package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.*;

/**
 * An object registry used to manage an object space. A registry can
 * have a parent registry. Looking for an object propagates along
 * the parent chain.
 */
public class Registry implements Serializable {
	private Registry fParent = null;
	private Hashtable fRegistry = null;
	private int fOId = 1000;
	private boolean fUnderDestruction = false;
/**
 * Creates a registry with the given parent. Parent may be null.
 */
public Registry(Registry parent) {
	fParent = parent;
	fRegistry = new Hashtable();
}
/**
 * Dispose the registry and tell all the registered objects to free
 * themselves.
 */
public synchronized void dispose() {
	if (fUnderDestruction)
		return;
	fUnderDestruction = true;
	if (fRegistry != null) {
		Enumeration e = fRegistry.elements();
		while (e.hasMoreElements()) {
			try {
				ICallable c = (ICallable) e.nextElement();
				if (c != null) {
					c.free();
				}
			} catch (Exception ex) {
			}
		}
		fRegistry.clear();
		fRegistry= null;
	}
}
/**
 * Finds an object with the given object id.
 */
public ICallable find(int oid) {
	return internalFind(new Long(oid));
}
/**
 * Returns the registry.
 */
public Hashtable getRegistry() {
	return fRegistry;
}
private synchronized ICallable internalFind(Long oid) {
	if (fRegistry == null)
		return null;
	ICallable c = (ICallable) fRegistry.get(oid);
	if (c == null && fParent != null)
		c = fParent.internalFind(oid);
	return c;
}
/**
 * Registers an object with a given id.
 */
public synchronized void register(int oid, ICallable c) {
	fRegistry.put(new Long(oid), c);
}
/**
 * Assigns an object id and registers the object.
 */
public synchronized int register(ICallable c) {
	int oid = fOId++;
	fRegistry.put(new Long(oid), c);
	return oid;
}
public synchronized void shutdown() {
	dispose();
	fParent= null;
}
/**
 * Unregisters an object.
 */
public synchronized void unregister(int oid) {
	fRegistry.remove(new Long(oid));
}
}
