package com.ibm.ulc.application;

/**
 * Implement an enabler that can take many sources and enables its target if 
 * only one of its source components is enabled.
 */
public class ULCXorEnabler extends ULCEnabler {
public ULCXorEnabler() {
	super();
}
/**
 * Add a ULCComponent to the list of components that must be enabled 
 * before my target component is enabled.
 *
 * @param c The component to be added.
 */
public void add(IEnabler c) {
	internalAdd(c);
}
/**
 * Remove a ULCComponent to the list of components that must be enabled before my 
 * target component is enabled.
 *
 * @param c The component to be added.
 */
public void remove(IEnabler c) {
	internalRemove(c);
}
/**
 * Convenience method for the Visual Composition editor to ensure it shows up as a property
 */
public void setXor(IEnabler c) {
	add(c);
}
}
