package com.ibm.ulc.application;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */

/** 
 * An event that characterizes a sort request on a table column.
 * @see ISortListener 
 */
public class ULCSortEvent extends ULCEvent {
	/** 
	 * The last column sorted or null if this is the first time a column is being sorted.
	 * @serial	 
	 */
	protected ULCColumn fLastSortedColumn = null;
	/** 
	 * The current column that has requested the sort.
	 * @serial	 
	 */
	protected ULCColumn fCurrentSortColumn = null;
	/** 
	 * The table that these columns reside in.
	 * @serial	 
	 */
	protected ULCTable fTable = null;
/** 
 * Create an event that characterizes a sort request on a table column.
 * @see ISortListener 
 */
public ULCSortEvent(ULCTable source, ULCColumn lastColumnSorted, ULCColumn currentSortColumn) {
	super(source);
	fLastSortedColumn = lastColumnSorted;
	fCurrentSortColumn = currentSortColumn;
}
/**
 * Dispatch this event to the listener if it implements the ISortListener interface.
 *
 * @param sortListener	The object that implements the  ISortListener interface.
 */
public void dispatch(IListener sortListener) {
	if (sortListener instanceof ISortListener) {
		ISortListener l = (ISortListener) sortListener;
		l.sortRequested(this);
	}
}
/**
 * Return the current column that has requested the sort.
 *
 */
public ULCColumn getCurrentSortColumn() {
	return fCurrentSortColumn;
}
/**
 * Return the last column that has been sorted in this table or null.
 *
 */
public ULCColumn getLastColumnSorted() {
	return fLastSortedColumn;
}
/**
 * Return the table upon which the event is dispatched.
 *
 */
public ULCTable getTable() {
	return (ULCTable)getSource();
}
}
