package com.ibm.ulc.application;

import com.ibm.ulc.util.UlcHashtable;
import java.util.Vector;
import java.lang.reflect.Method;
/**
 * This class provides a simple implementation of a hierarchical adapters used for adapting 
 * ULC hierarchical elements (e.g. nodesin a tree) onto the business objects providing 
 * the required data.
 */
public class ULCSimpleHierarchyAdapter extends ULCAdapter implements IHierarchyAdapter {
	private ULCAbstractTableModel fModel;
	private String fParentAttribute;
	private String fChildrenAttribute;
	private String fParentSelector;
	private String fChildrenSelector;
	private Object fRoot;
/**
 * Construct a new instance of the reciever without the model defined. The receiver will fail if both the
 * getChildrenSelector and the model are not defined.
 */
public ULCSimpleHierarchyAdapter() {
	super();
}
/**
 * Construct a new instance of the reciever with the model defined. The model is needed only if
 * the getChildrenSelector is not defined.
 */
public ULCSimpleHierarchyAdapter(ULCAbstractTableModel model) {
	super();
	fModel = model;
}
/**
 * getChildren method comment.
 */
java.util.Vector findChildren(Object node) {
	Vector answer = new Vector();
	int[] oids = fModel.getAllRowIds();
	for (int i = 0; i < oids.length; i++) {
		Object row = fModel.getRow(oids[i]);
		Object parent = getParent(row);
		if (parent != null) {
			if (parent.equals(node))
				answer.addElement(row);
		}
	}
	return answer;
}
/**
 * getChildCount method comment.
 */
public int getChildCount(Object node) {
	return getChildren(node).size();
}
/**
 * getChildren method comment.
 */
public java.util.Vector getChildren(Object node) {
	if (node == null)
		return new Vector();
	String childrenSelector = getChildrenSelector();
	if (childrenSelector == null) {
		return findChildren(node);
	}
	Method method = getMethod(node, childrenSelector);
	Vector answer = new Vector();
	try {
		answer = (Vector) method.invoke(node, new Object[0]);
	}
	catch (Throwable ie) {
	}
	return answer;
}
/**
 * Comment
 * @return java.lang.String
 */
public java.lang.String getChildrenAttribute() {
	return fChildrenAttribute;
}
/**
 * Comment
 * @return java.lang.String
 */
public java.lang.String getChildrenSelector() {
	if (fChildrenSelector == null) {
		String childrenAttribute = getChildrenAttribute();
		String selector = null;
		if (childrenAttribute != null) {
			selector = "get" + (childrenAttribute.substring(0, 1)).toUpperCase() + childrenAttribute.substring(1);
			fChildrenSelector = selector;
		}
	}
	return fChildrenSelector;
}
/**
 * getRoot method comment.
 */
public Object getDefaultRoot() {
	return fRoot;
}
/**
 * Return the getter method that matches the attributeName.
 */
private Method getMethod(Object object, String selector) {
	UlcHashtable methodCache = getMethodCache(object);
	Object o = methodCache.get(selector);
	if (o != null)
		return (java.lang.reflect.Method) o;
	Method method = null;
	try {
		method = object.getClass().getMethod(selector, new Class[0]);
	}
	catch (Throwable t) {
		return null;
	}
	methodCache.put(selector, method);
	return method;
}
/**
 * Set the receiver's methodCache for the specified class name
 */
private UlcHashtable getMethodCache(Object model) {
	return super.getMethodCache(model.getClass().getName());
}
/**
 * Answer the parent of the specified node. Answer null if there is no parent.
 */
public Object getParent(Object node) {
	Method method = getMethod(node, getParentSelector());
	Object answer = null;
	try {
		answer = method.invoke(node, new Object[0]);
	}
	catch (Throwable ie) {
	}
	return answer;
}
public String getParentAttribute() {
	return fParentAttribute;
}
public String getParentSelector() {
	if (fParentSelector == null) {
		String parentAttribute = getParentAttribute();
		String selector = null;
		if (parentAttribute != null) {
			selector = "get" + (parentAttribute.substring(0, 1)).toUpperCase() + parentAttribute.substring(1);
			fParentSelector = selector;
		}
	}
	return fParentSelector;
}
/**
 * isChildrenAttribute method comment.
 */
public boolean isChildrenAttribute(String attributeName) {
	return attributeName != null && getChildrenAttribute() != null && getChildrenAttribute().equals(attributeName);
}
/**
 * isParentAttribute method comment.
 */
public boolean isParentAttribute(String attributeName) {
	return attributeName != null && getParentAttribute() != null && getParentAttribute().equals(attributeName);
}
/**
 * Comment
 * @param newChildrenAttribute java.lang.String
 */
public void setChildrenAttribute(java.lang.String newChildrenAttribute) {
	fChildrenAttribute = newChildrenAttribute;
}
/**
 * Comment
 * @param newChildrenSelector java.lang.String
 */
public void setChildrenSelector(java.lang.String newChildrenSelector) {
	fChildrenSelector = newChildrenSelector;
}
/**
 * Comment
 * @param newRoot java.lang.Object
 */
public void setModel(ULCAbstractTableModel tableModel) {
	fModel = tableModel;
}
public void setParentAttribute(String parentAttribute) {
	fParentAttribute = parentAttribute;
}
public void setParentSelector(String parentSelector) {
	fParentSelector = parentSelector;
}
/**
 * Set the given object as the new root for the receiver
 *
 * @param 	newRoot 	Object	The new root for the receiver's hierarchy
 */
public void setRoot(Object newRoot) {
	fRoot = newRoot;
}
}
