package com.ibm.ulc.application;

import com.ibm.ulc.util.*;
/**
 * Implement an enabler that inverts the normal enabler logic.
 */
public class ULCNotEnabler extends ULCEnabler {
	/**
	 * The widget that if specified will cause this widget to be enabled in the UI.
	 * @serial	 
	 */
	protected IEnabler fEnabler = null;
public ULCNotEnabler() {
	super();
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fEnabler != null)
		a.put("enabler", fEnabler.getRef(fContext));
}
/**
 * Makes the enabled state of this widget dependent on the specified enabler widget.
 *
 * @param c The component that will enable/disable this object.
 */
public void setNot(IEnabler c) {
	fEnabler = c;
}
}
