package com.ibm.ulc.application;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.io.*;
import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;

/**
 * Implements the protocol of a <code>Graphics</code> and writes 
 * all operations onto its DataOutputStream.
 * The contents of this stream can be sent to the UI to be played
 * back onto an actual Graphics pane.
 *
 * Note: Though this class implements the entire API of the Graphics 
 * some methods are only stub implementations and do not currently work.
 * In addition it is important to note that the <code>setFont</code> API should not be
 * called in server environments that do not have a configured display. 
 * Use the <code>setULCFont</code> API which will work in both scenarios.
 * To portably call setFont on either a <code>Graphics</code> or <code>ULCGraphics</code>
 * use the helper method <code>setFontOn</code>.
 * For documentation of the individual API methods look for the same methods
 * in <code>Graphics</code>.
 * 
 * @see ULCGraphicsPane
 * @see Graphics
 */
public class ULCGraphics extends Graphics implements IUlcGraphicsDefaults {
	private DataOutputStream fGraphicsBuffer = null;
	private Color fColor = null;
	private ULCFont fFont = null;
	private Rectangle fClip = null;
public ULCGraphics(DataOutputStream dataOutputStream) {
	fGraphicsBuffer = dataOutputStream;
}
/**
 * @see Graphics#clearRect
 */
public void clearRect(int x, int y, int width, int height) {
	writeByte((byte) ULC_clearRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
}
/**
 * @see Graphics#clipRect
 */
public void clipRect(int x, int y, int width, int height) {
	writeByte((byte) ULC_clipRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	if (fClip != null)
		fClip = fClip.intersection(new Rectangle(x, y, width, height));
}
/**
 * @see Graphics#copyArea
 */
public void copyArea(int x, int y, int width, int height, int dx, int dy) {
	writeByte((byte) ULC_copyArea);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeShort(dx);
	writeShort(dy);
}
/**
 * @see Graphics#create
 */
public Graphics create() {
	return new ULCGraphics(fGraphicsBuffer);
}
/**
 * @see Graphics#dispose
 */
public void dispose() {
	writeByte((byte) ULC_dispose);
	flush();
}
/**
 * @see Graphics#draw3DRect
 */
public void draw3DRect(int x, int y, int width, int height, boolean raised) {
	writeByte((byte) ULC_draw3DRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeBoolean(raised);
}
/**
 * @see Graphics#drawArc
 */
public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
	writeByte((byte) ULC_drawArc);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeShort(startAngle);
	writeShort(arcAngle);
}
/**
 * @see Graphics#drawBytes
 */
public void drawBytes(byte data[], int offset, int length, int x, int y) {
	writeByte((byte) ULC_drawBytes);
	writeShort(offset);
	writeShort(length);
	for (int i = offset; i < offset + length; i++)
		writeByte(data[i]);
	writeShort(x);
	writeShort(y);
}
/**
 * @see Graphics#drawChars
 */
public void drawChars(char data[], int offset, int length, int x, int y) {
	writeByte((byte) ULC_drawChars);
	writeShort(offset);
	writeShort(length);
	for (int i = offset; i < offset + length; i++)
		writeShort(data[i]);
	writeShort(x);
	writeShort(y);
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
	System.out.println("not implemented");
	return false;
}
/**
 * Not yet implemented.
 * @see Graphics#drawImage
 */
public void drawImage(String name, int x, int y) {
	try {
		drawImage(new java.net.URL("file", "", name), x, y);
	} catch (java.net.MalformedURLException e) {
		System.out.println(e + "in drawImage");
	}
}
/**
 * @see Graphics#drawImage
 */
public void drawImage(java.net.URL url, int x, int y) {
	InputStream stream = null;
	byte d[] = null;
	if (url != null) {
		try {
			stream = url.openStream();
		} catch (IOException e) {
			System.out.println(e + "in drawImage");
		}
	} else {
		System.out.println("getIconData: fURL is null");
		return;
	}
	if (stream == null) {
		System.out.println("getIconData: fURL is null");
		return;
	}
	try {
		ByteArrayOutputStream data = new ByteArrayOutputStream();
		int b = 0;
		while ((b = stream.read()) != -1)
			data.write(b);
		stream.close();
		data.close();
		d = data.toByteArray();
	} catch (IOException e) {
		System.out.println("getIconData: " + "IOException while reading " + url);
	}
	writeByte((byte) ULC_drawImage);
	writeShort(x);
	writeShort(y);
	writeBytes(d);
}
/**
 * @see Graphics#drawLine
 */
public void drawLine(int x1, int y1, int x2, int y2) {
	writeByte((byte) ULC_drawLine);
	writeShort(x1);
	writeShort(y1);
	writeShort(x2);
	writeShort(y2);
}
/**
 * @see Graphics#drawOval
 */
public void drawOval(int x, int y, int width, int height) {
	writeByte((byte) ULC_drawOval);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
}
/**
 * @see Graphics#drawPolygon
 */
public void drawPolygon(int xPoints[], int yPoints[], int nPoints) {
	drawPolygon(new Polygon(xPoints, yPoints, nPoints));
}
/**
 * @see Graphics#drawPolygon
 */
public void drawPolygon(Polygon p) {
	writeByte((byte) ULC_drawPolygon);
	writeSerializable(p);
}
/**
 * @see Graphics#drawPolyline
 */
public void drawPolyline(int xPoints[], int yPoints[], int nPoints) {
	writeByte((byte) ULC_drawPolyline);
	writeSerializable(new Polygon(xPoints, yPoints, nPoints));
}
/**
 * @see Graphics#drawRect
 */
public void drawRect(int x, int y, int width, int height) {
	writeByte((byte) ULC_drawRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
}
/**
 * @see Graphics#drawRoundRect
 */
public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
	writeByte((byte) ULC_drawRoundRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeShort(arcWidth);
	writeShort(arcHeight);
}
/**
 * @see Graphics#drawString
 */
public void drawString(String str, int x, int y) {
	writeByte((byte) ULC_drawString);
	writeString(str);
	writeShort(x);
	writeShort(y);
}
/**
 * Not yet implemented.
 * @see Graphics#drawString
 */
public void drawString(java.text.AttributedCharacterIterator iterator, int x, int y) {
	System.out.println("drawString(AttributedCharacterIterator iterator, int x, int y) not yet implemented");
}
/**
 * @see Graphics#fill3DRect
 */
public void fill3DRect(int x, int y, int width, int height, boolean raised) {
	writeByte((byte) ULC_fill3DRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeBoolean(raised);
}
/**
 * @see Graphics#fillArc
 */
public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
	writeByte((byte) ULC_fillArc);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeShort(startAngle);
	writeShort(arcAngle);
}
/**
 * @see Graphics#fillOval
 */
public void fillOval(int x, int y, int width, int height) {
	writeByte((byte) ULC_fillOval);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
}
/**
 * @see Graphics#fillPolygon
 */
public void fillPolygon(int xPoints[], int yPoints[], int nPoints) {
	fillPolygon(new Polygon(xPoints, yPoints, nPoints));
}
/**
 * @see Graphics#fillPolygon
 */
public void fillPolygon(Polygon p) {
	writeByte((byte) ULC_fillPolygon);
	writeSerializable(p);
}
/**
 * @see Graphics#fillRect
 */
public void fillRect(int x, int y, int width, int height) {
	writeByte((byte) ULC_fillRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
}
/**
 * @see Graphics#fillRoundRect
 */
public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
	writeByte((byte) ULC_fillRoundRect);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	writeShort(arcWidth);
	writeShort(arcHeight);
}
/**
 * Forces all accumalated changes to be writted to the OutputStream
 */
public void flush() {
	try {
		fGraphicsBuffer.flush();
	} catch (Exception e) {
		System.out.println(e + "in flush");
	}
}
/**
 * @see Graphics#getClip
 */
public Shape getClip() {
	return fClip;
}
/**
 * @see Graphics#getClipBounds()
 */
public Rectangle getClipBounds() {
	return fClip;
}
/**
 * @see Graphics#getClipBounds()
 */
public Rectangle getClipRect() {
	return fClip;
}
/**
 * @see Graphics#getColor
 */
public Color getColor() {
	return fColor;
}
/**
 * Returns the DataOutputStream upon which all operation that this Graphics performs is recorded.
 */
public DataOutputStream getDataStream() {
	return fGraphicsBuffer;
}
/**
 * This method should not be called since on server environments the display is
 * unknown and hence would cause a exception when creating a Font.
 * @see #setULCFont
 * @see #getULCFont
 */
public Font getFont() {
	return getFont(fFont);
}
/**
 * Convenience method to convert a ULCFont to a Font.
 * This method should not be called on server environments since the display is
 * unknown and hence would cause a exception when creating a Font.
 * @see #setULCFont
 * @see #getULCFont
 */
public static Font getFont(ULCFont ulcFont) {
	return new Font(ulcFont.fName, ulcFont.fStyle, ulcFont.fSize);
}
/**
 * This method should not be called since on server environments the display is
 * unknown and hence would cause a exception when creating a Font.
 */
public FontMetrics getFontMetrics() {
	return (fFont == null) ? null : getFontMetrics(getFont());
}
/**
 * This method should not be called since on server environments the display is
 * unknown and hence would cause a exception when creating a Font.
 */
public FontMetrics getFontMetrics(Font f) {
	/*
	 * This is a hack which has been made because
	 * Toolkit.getFontMetrics(Font) has been deprecated
	 */
	return new Label().getFontMetrics(f);
}
/**
 * Return the current ULCFont used within this Graphics
 * @see #setFont
 * @see #getFont
 */
public ULCFont getULCFont() {
	return fFont;
}
/**
 * @see Graphics#setClip
 */
public void setClip(int x, int y, int width, int height) {
	writeByte((byte) ULC_setClip);
	writeShort(x);
	writeShort(y);
	writeShort(width);
	writeShort(height);
	fClip = new Rectangle(x, y, width, height);
}
/**
 * @see Graphics#setClip
 */
public void setClip(Shape clip) {
	writeByte((byte) ULC_setClip);
	Rectangle r = clip.getBounds();
	writeShort(r.x);
	writeShort(r.y);
	writeShort(r.width);
	writeShort(r.height);
	fClip = r;
}
/**
 * @see Graphics#setColor
 */
public void setColor(Color c) {
	writeByte((byte) ULC_setColor);
	writeSerializable(c);
	fColor = c;
}
/**
 * Sets the DataOutputStream upon which all operation that this Graphics performs is recorded.
 */
public void setDataStream(DataOutputStream dataOutputStream) {
	fGraphicsBuffer = dataOutputStream;
}
/**
 * This method should not be called since on server environments the display is
 * unknown and hence would cause a exception when creating a Font.
 * @see #setULCFont
 * @see #getULCFont
 */
public void setFont(Font f) {
	System.out.println("Do not call setFont(Font) use setULCFont(ULCFont)");
}
/**
 * Convenience method to portably handle a mix of Graphics and ULCGraphics.
 * Server environments that do not have a display should not attempt to
 * create a Font.
 */
public static void setFontOn(Graphics g, ULCFont font) {
	if (g instanceof ULCGraphics)
		 ((ULCGraphics) g).setULCFont(font);
	else
		g.setFont(getFont(font));
}
/**
 * @see Graphics#setPaintMode
 */
public void setPaintMode() {
	writeByte((byte) ULC_setPaintMode);
}
/**
 * Set the current ULCFont used within this Graphics
 * @see #setFont
 * @see #getFont
 */
public void setULCFont(ULCFont f) {
	writeByte((byte) ULC_setFont);
	writeString(f.fName);
	writeShort(f.fStyle);
	writeShort(f.fSize);
	fFont = f;
}
/**
 * @see Graphics#setXORMode
 */
public void setXORMode(Color c) {
	writeByte((byte) ULC_setXORMode);
	writeSerializable(c);
}
/**
 * @see Graphics#translate
 */
public void translate(int x, int y) {
	writeByte((byte) ULC_translate);
	writeShort(x);
	writeShort(y);
	fClip.translate(x, y);
}
void writeBoolean(boolean b) {
	try {
		fGraphicsBuffer.writeByte((byte) (b ? 1 : 0));
	} catch (Exception e) {
		System.out.println(e + "in writeBoolean");
	}
}
void writeByte(byte b) {
	try {
		fGraphicsBuffer.writeByte(b);
	} catch (Exception e) {
		System.out.println(e + "in writeByte");
	}
}
void writeBytes(byte b[]) {
	try {
		fGraphicsBuffer.writeShort(b.length);
		for (int i = 0; i < b.length; i++)
			fGraphicsBuffer.writeByte(b[i]);
	} catch (Exception e) {
		System.out.println(e + "in writeBytes");
	}
}
void writeInt(int i) {
	try {
		fGraphicsBuffer.writeInt(i);
	} catch (Exception e) {
		System.out.println(e + "in writeInt");
	}
}
void writeSerializable(Serializable o) {
	try {
		ObjectOutputStream oos = new ObjectOutputStream(fGraphicsBuffer);
		oos.writeObject(o);
	} catch (Exception e) {
		System.out.println(e + "in writeSerializable");
	}
}
void writeShort(int i) {
	try {
		fGraphicsBuffer.writeShort((short) i);
	} catch (Exception e) {
		System.out.println(e + "in writeShort");
	}
}
void writeString(String s) {
	try {
		int i = s.length();
		fGraphicsBuffer.writeShort(i);
		fGraphicsBuffer.writeBytes(s);
	} catch (Exception e) {
		System.out.println(e + "in writeString");
	}
}
}
