package com.ibm.ulc.application;

import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.base.*;
import com.ibm.ulc.util.ITableRow;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
/**
 * Implement a generic Form Model that can be used for simple applications
 */
public class GenericFormModel extends ULCFormModel implements IDefaults {
	/**
	 *
	 * @serial
	 */
	protected ITableRow fData = new UlcHashtable();
/**
 * GenericFormModel constructor .
 */
public GenericFormModel() {
	super();
}
/**
 * Create a GenericFormModel with the specified notification policy.
 *
 * @param policy int
 * <pre>
 * The Notification policy can be one of:
 *
 * 	FORM_NOTIFICATION_IMMEDIATE
 *		any changes in the form field are immediately
 *		reported back to the application.
 *
 *	FORM_NOTIFICATION_ON_REQUEST
 *		Changes will be reported back only when the user explicitly calls
 *		<code>saveInput</code> on the FormModel.
 *
 * </pre>
 */
public GenericFormModel(int policy) {
	super(policy);
}
/**
 * Registers the given listener to begin receiving notifications
 * when changes are made to the field.
 * The listener will be notified when this formModel is updated from the UI and 
 * after the values have been updated locally.
 *
 * The ULCValueChangedEvent will contain a UlcHashtable containing the attributeName and 
 * new value of each change.
 *
 * @param listener	The object interested in my changes.
 */
public void addValueChangedListener(IValueChangedListener listener) {
	internalAddListener("setData", listener);
}
/**
 * Return my ITableRow object.
 * 
 */
public ITableRow getValue() {
	return fData;
}
/**
 * Return the value at the specified formAttributeName or null if no value exists.
 * 
 */
public Object getValueAt(String formAttributeName) {
	return fData.getValueAt(formAttributeName);
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
synchronized public void handleRequest(ORBConnection conn, String request, Anything args) {
	super.handleRequest(conn, request, args);
	if (request.equals("setData")) {
		Anything data = args.get("data");
		UlcHashtable changes = new UlcHashtable();
		for (int i = 0; i < data.size(); i++) {
			String key = data.slotName(i);
			Anything value = data.get(i);
			if (key != null && value != null)
				changes.setValueAt(convert(value), key);
		}
		distributeToListeners("setData", new ULCValueChangedEvent(this, changes));
		return;
	}
}
/**
 * Notify the UI that a change has occurred in the specified formAttrinbuteName
 * This will cause the UI to request the value once again from the application.
 *

 * @param formAttributeName 	The key at which the change occurred.
 */
public void notifyChange(String formAttributeName) {
	notify(FORM_MODEL_CHANGED, formAttributeName);
}
/**
 * Unregisters the given observer from the notification list
 * so it will no longer receive value changed events.
 * The listener will be notified when this formModel is updated from the UI and 
 * after the values have been updated locally.
 *
 * The ULCValueChangedEvent will contain a UlcHashtable containing the attributeName and 
 * new value of each change.
 *
 * @param listener	The object that was interested in my changes.
 */
public void removeValueChangedListener(IValueChangedListener listener) {
	internalRemoveListener("setData", listener);
}
/**
 * Set my ITableRow object.
 * 
 */
public void setValue(ITableRow tableRow) {
	fData = tableRow;
}
/**
 * Set the object at the specified formAttributeName to be  value.
 *
 * @param value				 	The value to be set at the specified key.
 * @param formAttributeName 	The key at which the change occurred.
 */
public void setValueAt(Object value, String formAttributeName) {
	fData.setValueAt(value, formAttributeName);
}
}
