package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.UlcObject;
/**
 * Implement the <code>IWindowListener</code> interface with stub implementations.
 * Default behavior is to do nothing. Subclasses can override individual actions.
 */
public class DefaultWindowListener extends UlcObject implements IWindowListener {
/**
 * Notification of a Window brought to top in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowActivatedListener
 */
public void windowActivated(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a window being closed in the UI. 
 * This event will be received only if a listener has been 
 * registered for this event or if the window is modal.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowClosedListener
 */
public void windowClosed(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window about to be closed in the UI.
 * This event will be received only if the veto flag is enabled for the window. 
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowClosingListener
 */
public void windowClosing(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window loosing focus in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowDeactivatedListener
 */
public void windowDeactivated(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window being hidden in the UI.
 * This event will be received only if the window is modal or
 * if a listener has been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowHiddenListener
 */
public void windowHidden(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window being moved in the UI.
 * This event is a piggybacked event and will be received only
 * along with the next non-piggybacked event and only 
 * if a listener has been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowMovedListener
 */
public void windowMoved(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window being resized in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowResizedListener
 */
public void windowResized(ULCWindowEvent windowEvent) {
}
/**
 * Notification of a Window being shown in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowShownListener
 */
public void windowShown(ULCWindowEvent windowEvent) {
}
}
