import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import mplayer.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'Form1' is
 * created in the main() method.
 */
public class Form1 extends Form 
{

	IISCMPlayer mplayer;
	
	
	private String m_Filename; // the most recently-used filename
	private boolean m_FileOpen = false; // set true after first file is opened.
	
	
	public Form1()
	{
		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
	}

	/**
	 * Form1 overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void Form1_click(Object source, Event e)
	{
		
	}
	private void menuItem8_click(Object source, Event e)
	{
		
	}

	
	private void FileMenuExit_click(Object source, Event e)
	{
		Application.exit();
	}

	private void OptionsMenuStatistics_click(Object source, Event e)
	{
		int result = new StatisticsDialog().showDialog(this);
	}

	private void FileMenuOpen_click(Object source, Event e)
	{
		//Create an Open File dialog box
		OpenFileDialog ofd = new OpenFileDialog();
		//Set up filter and options
		ofd.setFilter("Video Files (*.mpg)|*.mpg|IBM Internet Video Files (*.ivs)|*.ivs|All Files (*.*)|*.*");

		ofd.setDefaultExt("mpg");
		//Run the Open File dialog box
		int dlgResult = ofd.showDialog();
      
		short [] v_height = new short[3];
		short [] v_width = new short[3];
		short height = (short)0;
		short width = (short)0;
		short short_zero = 0;
                    
		//Check result of dialog box after it closes
        if (dlgResult == DialogResult.OK) {

			//Retrieve the filename entered
			m_Filename = ofd.getFileName();
			
			m_FileOpen=true;
			
			
			mplayer = new ISCMPlayer(); 
 

  
				 
	        if(  m_Filename.equals(""))
	        {
		           ofd.dispose();
		           return;
			}
			mplayer.Cleanup();
				
            String metafile;

            short[] err = new short[3];
			
		    mplayer.SetMetaData(m_Filename, err);

			mplayer.Initialize( getHandle(), 0, (short)0);

		    mplayer.GetVideoSize(v_width, v_height);
            mplayer.SetWindowPos(0, short_zero, short_zero, v_width[0], v_height[0]);
		    setSize(v_width[0], v_height[0]+48);
		    setLeft(0);
		    setTop(0);
            short short_50 = (short)50;
		    short short_250 = (short)250;
		    show();
        	if (v_width[0] == short_zero )  // Audio Clip
		    {
			
		            short short_75 = (short)75;
		            width = short_50;
		            height = short_75;
                            mplayer.SetWindowPos(0, short_zero, short_zero, v_width[0], v_height[0]);
		    }
		    else                // Video Clip
		    {
					short short_10 = (short)10;
            	    mplayer.SetWindowPos(0, short_zero, short_zero, v_width[0], v_height[0]);

		    }
            mplayer.Play();

						
		}
	}

	private void ControlsMenuPause_click(Object source, Event e)
	{
		
		mplayer = new ISCMPlayer(); 
        mplayer.Pause();
	}

	private void ControlsMenuStop_click(Object source, Event e)
	{
		mplayer = new ISCMPlayer(); 
        mplayer.Stop();
	}

	private void ControlsMenuPlay_click(Object source, Event e)
	{
		mplayer = new ISCMPlayer(); 
        mplayer.Play();
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	MainMenu Menu = new MainMenu();
	MenuItem FileMenu = new MenuItem();
	MenuItem FileMenuExit = new MenuItem();
	MenuItem FileMenuOpen = new MenuItem();
	MenuItem ControlsMenu = new MenuItem();
	MenuItem ControlsMenuPlay = new MenuItem();
	MenuItem ControlsMenuPause = new MenuItem();
	MenuItem ControlsMenuStop = new MenuItem();
	MenuItem OptionsMenu = new MenuItem();
	MenuItem OptionsMenuStatistics = new MenuItem();

	private void initForm()
	{
		FileMenuExit.setText("E&xit        Esc");
		FileMenuExit.addOnClick(new EventHandler(this.FileMenuExit_click));

		FileMenuOpen.setText("&Open...  Ctrl+O");
		FileMenuOpen.addOnClick(new EventHandler(this.FileMenuOpen_click));

		FileMenu.setMenuItems(new MenuItem[] {
							  FileMenuOpen, 
							  FileMenuExit});
		FileMenu.setText("&File");

		ControlsMenuPlay.setText("&Play");
		ControlsMenuPlay.addOnClick(new EventHandler(this.ControlsMenuPlay_click));

		ControlsMenuPause.setText("P&ause");
		ControlsMenuPause.addOnClick(new EventHandler(this.ControlsMenuPause_click));

		ControlsMenuStop.setText("&Stop");
		ControlsMenuStop.addOnClick(new EventHandler(this.ControlsMenuStop_click));

		ControlsMenu.setMenuItems(new MenuItem[] {
								  ControlsMenuPlay, 
								  ControlsMenuPause, 
								  ControlsMenuStop});
		ControlsMenu.setText("&Controls");

		OptionsMenuStatistics.setText("&Statistics");
		OptionsMenuStatistics.addOnClick(new EventHandler(this.OptionsMenuStatistics_click));

		OptionsMenu.setMenuItems(new MenuItem[] {
								 OptionsMenuStatistics});
		OptionsMenu.setText("&Options");
		OptionsMenu.addOnClick(new EventHandler(this.menuItem8_click));

		Menu.setMenuItems(new MenuItem[] {
						  FileMenu, 
						  ControlsMenu, 
						  OptionsMenu});
		/* @designTimeOnly Menu.setLocation(new Point(8, 8)); */

		this.setFont(new Font("Fixedsys", 11.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		this.setText("Sample J++ VC Media Player");
		this.setAutoScaleBaseSize(new Point(8, 15));
		this.setClientSize(new Point(292, 273));
		this.setMenu(Menu);
		this.addOnClick(new EventHandler(this.Form1_click));
	}

	/**
	 * The main entry point for the application. 
	 *
	 * @param args Array of parameters passed to the application
	 * via the command line.
	 */
	public static void main(String args[])
	{
		Application.run(new Form1());
	}



}
