//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\///
//       MainFrm.cpp : implementation of the CMainFrame class
//\/\/\/\/\/\\/\\/\/\/\/\/\/\/\/\/\/\/\/\/\\/\/\/\/\/\/\\/\/\/\/\//
///////////////////////////////////////////////////////////////////
//===========================================================================
//
//             I B M    P R O P R I E T A R Y    S O U R C E    C O D E
//                             C O N F I D E N T I A L
//
//     Copyright (c) 1997 by International Buisiness Machines.  All
//     rights reserved.
//
//===========================================================================

#include "stdafx.h"
#include "vcPlayer.h"
#include "iscplaysdk.h"

////////////////////////////////////////////////////////////////////
// CMainFrame
////////////////////////////////////////////////////////////////////
extern IISCMPlayerPtr pISCMPlayer;

CWinThread* pHmThread;

extern UINT RWM_NEWMOVIE;

UINT WM_ISCEVENT = RegisterWindowMessage(szISCEvent);

//extern IISCMPlayerPtr pISCMPlayer;

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
    //{{AFX_MSG_MAP(CMainFrame)
    ON_WM_CREATE()
	ON_WM_NCCREATE()
    ON_COMMAND(ID_FILE_OPENFILE, OnFileOpenfile)
    ON_UPDATE_COMMAND_UI(ID_FILE_OPENFILE, OnUpdateFileOpenfile)
	ON_WM_CLOSE()
	ON_WM_NCPAINT()
	ON_WM_SIZE()
	ON_COMMAND(ID_STATISTICS, OnStatistics)
	//}}AFX_MSG_MAP

    ON_REGISTERED_MESSAGE(RWM_NEWMOVIE, OnNewMovie)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
  
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
        return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
        CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
        CFrameWnd::Dump(dc);
}

#endif 

/////////////////////////////////////////////////////////////////////////////
// Streaming a media file from VideoCharger server
// Activated by matching mime type of *.IVS.

HRESULT CMainFrame::OnNewMovie(UINT wParam, LONG lParam)
{      
	CWaitCursor wait;

	pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);

    CString cs = AfxGetApp()->GetProfileString("Video_Viewer", "New_File");
	if(cs.IsEmpty())
			return 0;
	
    WCHAR   metafile[MAX_PATH];
    MultiByteToWideChar(CP_ACP, 0, cs, -1, metafile, MAX_PATH);
   
	HRESULT rc;
	if(wParam)
		rc = pISCMPlayer->Initialize((OAHWND)GetSafeHwnd(), FALSE, 0);	
	else
		rc = pISCMPlayer->NewClip((OAHWND)GetSafeHwnd(), 0);

	if(rc == S_OK)
		pISCMPlayer->Play();

	SetFocus();
    return 1;
}

/////////////////////////////////////////////////////////////////////////////
// Open a local media file using a FILE DIALOG box

void CMainFrame::OnFileOpenfile()
{
	short v_height, v_width;
	CString openStr, ext;

 	openStr.LoadString(IDS_FILEFILTER);
    pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
	CFileDialog *dlg = new CFileDialog(TRUE, NULL, NULL,
				OFN_HIDEREADONLY, openStr, NULL);

	if(dlg->DoModal() != IDOK)
	{
		delete dlg;
		return;
	}

	CString mName = dlg->GetPathName();
	if(  mName.IsEmpty())
	{
		delete dlg;
		return ;
	}

	delete dlg;

	pISCMPlayer->Cleanup();
				
	WCHAR   metafile[MAX_PATH];
    MultiByteToWideChar(CP_ACP, 0, mName, -1, metafile, MAX_PATH);
	
    short err;
    if ( pISCMPlayer->SetMetaData(metafile, &err) == S_OK) {
		AfxGetApp()->WriteProfileString("Video_Viewer", "New_File", mName);
	}

	else
	{
		if(err == 2)
		{
			OnClose();
			_exit(2);
		}
	}
		
    if(pISCMPlayer->Initialize( (OAHWND)GetSafeHwnd(), FALSE, 0) == S_OK) 
    {
		pISCMPlayer->GetVideoSize(&v_width, &v_height);
        pISCMPlayer->SetWindowPos(NULL, 0, 0, v_width, v_height);

		if (v_width == 0 )  // Audio Clip
		{
            SetWindowPos(NULL, 0, 0, v_width+50, v_height+75, SWP_NOMOVE);
        }
		else                // Video Clip
        {
			SetWindowPos(NULL, 0, 0, v_width+10, v_height+50, SWP_NOMOVE);

        }
        pISCMPlayer->Play();
    }
	
	SetFocus();
}

/////////////////////////////////////////////////////////////////////////////
// Clean up before closing app 

void CMainFrame::OnClose() 
{
	CWaitCursor wait;
	
	pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);	
	pISCMPlayer->Cleanup();
		
	CFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
// Standard Window stuff

void CMainFrame::OnUpdateFileOpenfile(CCmdUI* pCmdUI)
{
                 pCmdUI->Enable();
}

void CMainFrame::PostNcDestroy()
{
        ( (vcPlayerApp*)AfxGetApp() )->m_pMainWnd == NULL;
}

int CMainFrame::OnNcCreate(LPCREATESTRUCT lpCreateStruct)
{
	return CFrameWnd::OnNcCreate(lpCreateStruct);
}




void CMainFrame::OnStatistics() 
{
	// TODO: Add your command handler code here
    StatisticsDialog sDlg;		

	if(sDlg.DoModal() != IDOK)
		return;

	
}
