/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.AfterInternalExecutionListener;
import com.ibm.ivj.eab.command.BeforeInternalExecutionListener;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.CommandException;
import com.ibm.ivj.eab.command.ExecutionException;
import com.ibm.ivj.eab.command.ExecutionSuccessfulListener;
import com.ibm.ivj.eab.command.ExecutionUnsuccessfulListener;
import com.ibm.ivj.eab.command.ICommand;
import com.ibm.ivj.eab.command.InternalExecutionStartingListener;
import com.ibm.ivj.eab.command.InvalidInputStateException;
import com.ibm.ivj.eab.command.InvalidOutputStateException;
import com.ibm.ivj.eab.command.InvalidTriggerStateException;
import com.ibm.ivj.eab.command.SelectorRecord;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Command
implements ICommand {
    private static ResourceBundle resCommandResourceBundle = ResourceBundle.getBundle("com.ibm.ivj.eab.command.CommandResourceBundle");
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    protected transient Vector aBeforeInternalExecutionListener = null;
    protected transient Vector aAfterInternalExecutionListener = null;
    protected transient Vector aExecutionSuccessfulListener = null;
    protected transient Vector aExecutionUnsuccessfulListener = null;
    protected transient Vector aInternalExecutionStartingListener = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private Object fieldInput = null;
    private Object fieldOutput = null;
    private Class fieldExpectedTriggerClass = null;

    public void addAfterInternalExecutionListener(AfterInternalExecutionListener newListener) {
        if (this.aAfterInternalExecutionListener == null) {
            this.aAfterInternalExecutionListener = new Vector();
        }
        this.aAfterInternalExecutionListener.addElement(newListener);
    }

    public void addBeforeInternalExecutionListener(BeforeInternalExecutionListener newListener) {
        if (this.aBeforeInternalExecutionListener == null) {
            this.aBeforeInternalExecutionListener = new Vector();
        }
        this.aBeforeInternalExecutionListener.addElement(newListener);
    }

    public void addExecutionSuccessfulListener(ExecutionSuccessfulListener newListener) {
        if (this.aExecutionSuccessfulListener == null) {
            this.aExecutionSuccessfulListener = new Vector();
        }
        this.aExecutionSuccessfulListener.addElement(newListener);
    }

    public void addExecutionUnsuccessfulListener(ExecutionUnsuccessfulListener newListener) {
        if (this.aExecutionUnsuccessfulListener == null) {
            this.aExecutionUnsuccessfulListener = new Vector();
        }
        this.aExecutionUnsuccessfulListener.addElement(newListener);
    }

    public void addInternalExecutionStartingListener(InternalExecutionStartingListener newListener) {
        if (this.aInternalExecutionStartingListener == null) {
            this.aInternalExecutionStartingListener = new Vector();
        }
        this.aInternalExecutionStartingListener.addElement(newListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public abstract void checkInputState() throws InvalidInputStateException;

    public void checkTriggerState(Object transferObject) throws InvalidTriggerStateException {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".checkTriggerState()]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        Object currentInput = this.getInput();
        if (this.getExpectedTriggerClass() != null && currentInput != null && transferObject.getClass() != this.getExpectedTriggerClass()) {
            throw new InvalidTriggerStateException();
        }
        if (currentInput == null) {
            try {
                this.setInput(transferObject);
                this.setInput(null);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                throw new InvalidTriggerStateException();
            }
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".checkTriggerState()]");
        }
    }

    public void execute() throws InvalidInputStateException, ExecutionException, InvalidOutputStateException {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute()]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        CommandEvent commandEvent = new CommandEvent(this);
        this.execute(commandEvent);
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute()]");
        }
    }

    public final void execute(CommandEvent event) throws InvalidInputStateException, ExecutionException, InvalidOutputStateException {
        CommandEvent commandEvent;
        block12: {
            if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent)]");
            }
            if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
            }
            commandEvent = new CommandEvent(this);
            commandEvent.setPropertyTable(event.getPropertyTable());
            try {
                this.fireBeforeInternalExecution(commandEvent);
            }
            catch (InvalidTriggerStateException invalidTriggerStateException) {
                if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                    RuntimeContext.getCurrent().getRASService().logTraceInfo("command.exectue(CommandEvent): InvalidTransferStateException");
                }
                return;
            }
            try {
                this.internalExecute();
            }
            catch (RuntimeException e) {
                commandEvent = new CommandEvent(this);
                commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Exception", e);
                this.fireAfterInternalExecution(commandEvent);
                this.fireExecutionUnsuccessful(commandEvent);
                if (!commandEvent.existsPropertyNamed("__ComIbmIvjEabCommand_Exception")) break block12;
                throw e;
            }
        }
        if (this.getOutput() instanceof SelectorRecord) {
            RuntimeContext.getCurrent().getRASService().logError(resCommandResourceBundle.getString("IVJC0850__No_output_candid"));
            if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo("   [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent) error: No output candidate matches data returned from the connector.]");
            }
            InvalidOutputStateException e = new InvalidOutputStateException();
            e.setInvalidOutput(((SelectorRecord)this.getOutput()).getInvalidOutput());
            commandEvent = new CommandEvent(this);
            this.fireAfterInternalExecution(commandEvent);
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Exception", e);
            this.fireExecutionUnsuccessful(commandEvent);
            if (commandEvent.existsPropertyNamed("__ComIbmIvjEabCommand_Exception")) {
                throw e;
            }
        }
        commandEvent = new CommandEvent(this);
        this.fireAfterInternalExecution(commandEvent);
        this.fireExecutionSuccessful(commandEvent);
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".execute(CommandEvent)]");
        }
    }

    protected void fireAfterInternalExecution(CommandEvent event) {
        if (this.aAfterInternalExecutionListener == null) {
            return;
        }
        int currentSize = this.aAfterInternalExecutionListener.size();
        AfterInternalExecutionListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (AfterInternalExecutionListener)this.aAfterInternalExecutionListener.elementAt(index);
            if (tempListener != null) {
                tempListener.afterInternalExecution(event);
            }
            ++index;
        }
    }

    protected void fireBeforeInternalExecution(CommandEvent event) {
        if (this.aBeforeInternalExecutionListener == null) {
            return;
        }
        int currentSize = this.aBeforeInternalExecutionListener.size();
        BeforeInternalExecutionListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (BeforeInternalExecutionListener)this.aBeforeInternalExecutionListener.elementAt(index);
            if (tempListener != null) {
                tempListener.beforeInternalExecution(event);
            }
            ++index;
        }
    }

    protected void fireExecutionSuccessful(CommandEvent event) {
        if (this.aExecutionSuccessfulListener == null) {
            return;
        }
        int currentSize = this.aExecutionSuccessfulListener.size();
        ExecutionSuccessfulListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (ExecutionSuccessfulListener)this.aExecutionSuccessfulListener.elementAt(index);
            if (tempListener != null) {
                tempListener.executionSuccessful(event);
            }
            ++index;
        }
    }

    protected void fireExecutionUnsuccessful(CommandEvent event) {
        if (this.aExecutionUnsuccessfulListener == null) {
            return;
        }
        int currentSize = this.aExecutionUnsuccessfulListener.size();
        ExecutionUnsuccessfulListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (ExecutionUnsuccessfulListener)this.aExecutionUnsuccessfulListener.elementAt(index);
            if (tempListener != null) {
                tempListener.executionUnsuccessful(event);
            }
            ++index;
        }
    }

    protected void fireInternalExecutionStarting(CommandEvent event) {
        if (this.aInternalExecutionStartingListener == null) {
            return;
        }
        int currentSize = this.aInternalExecutionStartingListener.size();
        InternalExecutionStartingListener tempListener = null;
        int index = 0;
        while (index < currentSize) {
            tempListener = (InternalExecutionStartingListener)this.aInternalExecutionStartingListener.elementAt(index);
            if (tempListener != null) {
                tempListener.internalExecutionStarting(event);
            }
            ++index;
        }
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public Class getExpectedTriggerClass() {
        return this.fieldExpectedTriggerClass;
    }

    public Object getInput() {
        return this.fieldInput;
    }

    public Object getOutput() {
        return this.fieldOutput;
    }

    public void internalExceptionHandler(Throwable exception) {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.Command@" + this.hashCode() + ".internalExceptionHandler()]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteOutput);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = byteOutput.toString();
        throw new CommandException("An error occured, please check stack trace for details.\n" + stackTrace);
    }

    protected abstract void internalExecute() throws ExecutionException;

    public void removeAfterInternalExecutionListener(AfterInternalExecutionListener newListener) {
        if (this.aAfterInternalExecutionListener != null) {
            this.aAfterInternalExecutionListener.removeElement(newListener);
        }
    }

    public void removeBeforeInternalExecutionListener(BeforeInternalExecutionListener newListener) {
        if (this.aBeforeInternalExecutionListener != null) {
            this.aBeforeInternalExecutionListener.removeElement(newListener);
        }
    }

    public void removeExecutionSuccessfulListener(ExecutionSuccessfulListener newListener) {
        if (this.aExecutionSuccessfulListener != null) {
            this.aExecutionSuccessfulListener.removeElement(newListener);
        }
    }

    public void removeExecutionUnsuccessfulListener(ExecutionUnsuccessfulListener newListener) {
        if (this.aExecutionUnsuccessfulListener != null) {
            this.aExecutionUnsuccessfulListener.removeElement(newListener);
        }
    }

    public void removeInternalExecutionStartingListener(InternalExecutionStartingListener newListener) {
        if (this.aInternalExecutionStartingListener != null) {
            this.aInternalExecutionStartingListener.removeElement(newListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setExpectedTriggerClass(Class expectedTriggerClass) {
        Class oldValue = this.fieldExpectedTriggerClass;
        this.fieldExpectedTriggerClass = expectedTriggerClass;
        this.firePropertyChange("expectedTriggerClass", oldValue, expectedTriggerClass);
    }

    public void setInput(Object input) {
        Object oldValue = this.fieldInput;
        this.fieldInput = input;
        this.firePropertyChange("input", oldValue, input);
    }

    public void setOutput(Object output) {
        Object oldValue = this.fieldOutput;
        this.fieldOutput = output;
        this.firePropertyChange("output", oldValue, output);
    }
}

