/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.InteractionSpec;
import com.ibm.connector.InteractionSpecModeProperties;
import com.ibm.connector.imstoc.IMSInteractionSpecProperties;
import com.ibm.connector.imstoc.IMSInteractionSpecResource;
import com.ibm.connector.imstoc.IMSTOCProperties;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.Serializable;

public class IMSInteractionSpec
implements InteractionSpec,
InteractionSpecModeProperties,
IMSInteractionSpecProperties,
IMSTOCProperties,
Serializable {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private int _mode = 0;
    private int _syncLevel = 0;
    private String _dataStoreName = "";
    private String _ltermName = "";
    private String _mapName = "";
    protected transient PropertyChangeSupport _changes = new PropertyChangeSupport(this);
    private static IMSInteractionSpecResource _res = new IMSInteractionSpecResource();

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        String methodName = String.valueOf(super.toString()) + ".addPropertyChangeListener (PropertyChangeListener)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._changes.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        String methodName = String.valueOf(super.toString()) + ".firePropertyChange(String, Object, Object)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._changes.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getDataStoreName() {
        String methodName = String.valueOf(super.toString()) + ".getDataStoreName()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._dataStoreName;
    }

    public String getLtermName() {
        String methodName = String.valueOf(super.toString()) + ".getLtermName()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._ltermName;
    }

    public String getMapName() {
        String methodName = String.valueOf(super.toString()) + ".getMapName()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._mapName;
    }

    public int getMode() {
        String methodName = String.valueOf(super.toString()) + ".getMode()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._mode;
    }

    public static String getModeText(int mode) {
        if (mode < 0 || mode >= 8) {
            return "INVALID_MODE: " + mode;
        }
        return IMSInteractionSpecProperties.MODE_TEXT[mode];
    }

    public int getSyncLevel() {
        String methodName = String.valueOf(super.toString()) + ".getSyncLevel()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._syncLevel;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        String methodName = String.valueOf(super.toString()) + ".removePropertyChangeListener(PropertyChangeListener)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        this._changes.removePropertyChangeListener(listener);
    }

    public void setDataStoreName(String newDataStoreName) {
        String methodName = String.valueOf(super.toString()) + ".setDataStoreName(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        String oldDataStoreName = this._dataStoreName;
        int len = newDataStoreName.length();
        if (len > 8) {
            String errMsg = _res.getString("0001E", new Object[]{methodName, newDataStoreName, new Integer(len), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._dataStoreName = newDataStoreName;
        this.firePropertyChange("fieldDataStoreName", oldDataStoreName, newDataStoreName);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
    }

    public void setLtermName(String newLtermName) {
        String methodName = String.valueOf(super.toString()) + ".setLtermName(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        String oldLtermName = this._ltermName;
        int len = newLtermName.length();
        if (len > 8) {
            String errMsg = _res.getString("0002E", new Object[]{methodName, newLtermName, new Integer(len), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._ltermName = newLtermName;
        this.firePropertyChange("fieldLtermName", oldLtermName, newLtermName);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setMapName(String newMapName) {
        String methodName = String.valueOf(super.toString()) + ".setMapName(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        String oldMapName = this._mapName;
        int len = newMapName.length();
        if (len > 8) {
            String errMsg = _res.getString("0003E", new Object[]{methodName, newMapName, new Integer(len), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._mapName = newMapName;
        this.firePropertyChange("fieldMapName", oldMapName, newMapName);
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setMode(int newMode) {
        String methodName = String.valueOf(super.toString()) + ".setMode(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        int oldMode = this._mode;
        if (newMode < 0 || newMode >= 8) {
            String errMsg = _res.getString("0004E", new Object[]{methodName, new Integer(newMode)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._mode = newMode;
        this.firePropertyChange("fieldMode", new Integer(oldMode), new Integer(newMode));
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setSyncLevel(int aSynclevel) {
        String methodName = String.valueOf(super.toString()) + ".setSyncLevel(String)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        int oldValue = this._syncLevel;
        if (aSynclevel < 0 || aSynclevel >= 2) {
            String errMsg = _res.getString("0005E", new Object[]{methodName, new Integer(aSynclevel)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._syncLevel = aSynclevel;
        this.firePropertyChange("SyncLevel", new Integer(oldValue), new Integer(aSynclevel));
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }
}

