/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.AlreadyConnectedException;
import com.ibm.connector.CommunicationException;
import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.InteractionSpec;
import com.ibm.connector.NotConnectedException;
import com.ibm.connector.imstoc.IMSAPIState;
import com.ibm.connector.imstoc.IMSAdapter;
import com.ibm.connector.imstoc.IMSConnectionResource;
import com.ibm.connector.imstoc.IMSConnectionSpec;
import com.ibm.connector.imstoc.IMSInteractionSpec;
import com.ibm.connector.imstoc.IMSLogonInfoItems;
import com.ibm.connector.imstoc.IMSTOCResourceException;
import com.ibm.connector.infrastructure.Coordinator;
import com.ibm.connector.infrastructure.Identifier;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.BadInvOrderException;
import com.ibm.connector.internal.HeuristicCommit;
import com.ibm.connector.internal.HeuristicHazard;
import com.ibm.connector.internal.HeuristicMixed;
import com.ibm.connector.internal.HeuristicRollback;
import com.ibm.connector.internal.Managed;
import com.ibm.connector.internal.NotPrepared;
import com.ibm.connector.internal.Resource;
import com.ibm.connector.internal.ResourceException;
import com.ibm.connector.internal.TransactionRolledBack;
import com.ibm.imstoc.IMSOutputSegment;
import com.ibm.imstoc.IMSOutputSegmentList;
import com.ibm.record.IByteBuffer;
import java.io.PrintWriter;
import java.util.Enumeration;

public class IMSConnection
implements Resource,
Managed {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private IMSAdapter _IMSAdapter = null;
    private IMSConnectionSpec _ConnectionSpec = null;
    private IMSInteractionSpec _InteractionSpec = null;
    private boolean _isInUse = true;
    private boolean _isDirty = false;
    protected Identifier _coordinationID = null;
    IMSConnectionResource _res = new IMSConnectionResource();

    public synchronized void call(InteractionSpec interactionSpec, Object input, Object output) throws ResourceException, CommunicationException, BadInvOrderException, IMSTOCResourceException {
        byte[] outputValue = null;
        byte[] inputValue = null;
        byte[] segByteArray = null;
        IMSOutputSegmentList oIMSOutList = null;
        int lenMsgObject = 0;
        int segOffset = 0;
        Enumeration en = null;
        IMSOutputSegment outSegA = null;
        String methodName = String.valueOf(super.toString()) + ".call(InteractionSpec, Object, Object)";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        IMSInteractionSpec oIMSInteractionSpec = (IMSInteractionSpec)interactionSpec;
        IMSAdapter oIMSAdapter = this.getIMSAdapter();
        int iInteractionMode = oIMSInteractionSpec.getMode();
        int iCommitMode = oIMSAdapter.getCommitMode();
        int iSyncLevel = oIMSAdapter.getSyncLevel();
        IMSAPIState imsAPIState = oIMSAdapter.getIMSAPIState();
        this._InteractionSpec = oIMSInteractionSpec;
        if (rasService.getTraceLevel() >= 3) {
            rasService.logTraceInfo(this.toString());
        }
        if (this.isDirty()) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        if (!oIMSAdapter.isConnected()) {
            String errMsg = this._res.getString("0002E", new Object[]{methodName});
            NotConnectedException e = new NotConnectedException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            imsAPIState.validateMode(oIMSInteractionSpec.getMode());
            switch (iInteractionMode) {
                case 1: 
                case 3: {
                    oIMSAdapter.setMode(iInteractionMode);
                    oIMSAdapter.setSyncLevel(oIMSInteractionSpec.getSyncLevel());
                    oIMSAdapter.setLtermName(oIMSInteractionSpec.getLtermName());
                    oIMSAdapter.setDataStoreName(oIMSInteractionSpec.getDataStoreName());
                    oIMSAdapter.setMapName(oIMSInteractionSpec.getMapName());
                    if (iInteractionMode == 3) {
                        oIMSAdapter.clearInputSegments();
                        oIMSAdapter.setCommitMode(0);
                        oIMSAdapter.setSyncLevel(1);
                    }
                    if (!(input instanceof IByteBuffer)) {
                        String errMsg = this._res.getString("0008E", new Object[]{methodName, new String("com.ibm.record.IByteBuffer")});
                        IllegalArgumentException e = new IllegalArgumentException(errMsg);
                        if (rasService.getTraceLevel() >= 2) {
                            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                            rasService.logTraceInfo(e.toString());
                            e.printStackTrace(printTraceWriter);
                        }
                        PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                        rasService.logError(e.toString());
                        e.printStackTrace(printErrorWriter);
                        throw e;
                    }
                    inputValue = ((IByteBuffer)input).getBytes();
                    oIMSAdapter.addInputSegment(inputValue, true);
                    oIMSAdapter.send();
                    break;
                }
                case 0: {
                    oIMSAdapter.setMode(iInteractionMode);
                    oIMSAdapter.setSyncLevel(oIMSInteractionSpec.getSyncLevel());
                    oIMSAdapter.setLtermName(oIMSInteractionSpec.getLtermName());
                    oIMSAdapter.setDataStoreName(oIMSInteractionSpec.getDataStoreName());
                    oIMSAdapter.setMapName(oIMSInteractionSpec.getMapName());
                    if (!(input instanceof IByteBuffer)) {
                        String errMsg = this._res.getString("0008E", new Object[]{methodName, new String("com.ibm.record.IByteBuffer")});
                        IllegalArgumentException e = new IllegalArgumentException(errMsg);
                        if (rasService.getTraceLevel() >= 2) {
                            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                            rasService.logTraceInfo(e.toString());
                            e.printStackTrace(printTraceWriter);
                        }
                        PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                        rasService.logError(e.toString());
                        e.printStackTrace(printErrorWriter);
                        throw e;
                    }
                    inputValue = ((IByteBuffer)input).getBytes();
                    oIMSAdapter.addInputSegment(inputValue, true);
                    oIMSAdapter.send();
                    oIMSOutList = (IMSOutputSegmentList)oIMSAdapter.receive(oIMSInteractionSpec);
                    if (output instanceof IByteBuffer) {
                        en = oIMSOutList.elements();
                        if (en.hasMoreElements()) {
                            outSegA = (IMSOutputSegment)en.nextElement();
                            lenMsgObject += outSegA.sizeOfOutputSegment();
                        }
                        outputValue = new byte[lenMsgObject];
                        en = oIMSOutList.elements();
                        if (en.hasMoreElements()) {
                            outSegA = (IMSOutputSegment)en.nextElement();
                            segByteArray = outSegA.getBytes();
                            int i = 0;
                            while (i < segByteArray.length) {
                                outputValue[segOffset + i] = segByteArray[i];
                                ++i;
                            }
                            segOffset += segByteArray.length;
                        }
                        ((IByteBuffer)output).setBytes(outputValue);
                        break;
                    }
                    String errMsg = this._res.getString("0009E", new Object[]{methodName, new String("com.ibm.record.IByteBuffer")});
                    IllegalArgumentException e = new IllegalArgumentException(errMsg);
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(e.toString());
                        e.printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(e.toString());
                    e.printStackTrace(printErrorWriter);
                    throw e;
                }
                case 2: {
                    oIMSOutList = (IMSOutputSegmentList)oIMSAdapter.receive(oIMSInteractionSpec);
                    if (output instanceof IByteBuffer) {
                        en = oIMSOutList.elements();
                        if (en.hasMoreElements()) {
                            outSegA = (IMSOutputSegment)en.nextElement();
                            lenMsgObject += outSegA.sizeOfOutputSegment();
                        }
                        outputValue = new byte[lenMsgObject];
                        en = oIMSOutList.elements();
                        if (en.hasMoreElements()) {
                            outSegA = (IMSOutputSegment)en.nextElement();
                            segByteArray = outSegA.getBytes();
                            int i = 0;
                            while (i < segByteArray.length) {
                                outputValue[segOffset + i] = segByteArray[i];
                                ++i;
                            }
                            segOffset += segByteArray.length;
                        }
                        ((IByteBuffer)output).setBytes(outputValue);
                        if (iCommitMode == 0 && iSyncLevel == 1) {
                            oIMSAdapter.sendAck();
                        }
                        break;
                    }
                    String errMsg = this._res.getString("0009E", new Object[]{methodName, new String("com.ibm.record.IByteBuffer")});
                    IllegalArgumentException e = new IllegalArgumentException(errMsg);
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(e.toString());
                        e.printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(e.toString());
                    e.printStackTrace(printErrorWriter);
                    throw e;
                }
                case 4: {
                    oIMSAdapter.sendAck();
                    if (imsAPIState.getState() == 2 && iCommitMode == 1) {
                        oIMSAdapter.receive(oIMSInteractionSpec);
                    }
                    break;
                }
                case 5: {
                    oIMSAdapter.sendNack();
                    if (iCommitMode == 1) {
                        oIMSAdapter.receive(oIMSInteractionSpec);
                        oIMSAdapter.sendAck();
                        oIMSAdapter.receive(oIMSInteractionSpec);
                    }
                    break;
                }
                case 6: {
                    oIMSAdapter.exitConversation();
                    break;
                }
                case 7: {
                    oIMSAdapter.setCommitMode(0);
                    oIMSAdapter.setSyncLevel(1);
                    oIMSAdapter.setDataStoreName(oIMSInteractionSpec.getDataStoreName());
                    oIMSAdapter.resumeTpipe();
                    break;
                }
                default: {
                    String errMsg = this._res.getString("0005E", new Object[]{methodName, new Integer(iInteractionMode)});
                    ResourceException e = new ResourceException(errMsg);
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                        rasService.logTraceInfo(e.toString());
                        e.printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(e.toString());
                    e.printStackTrace(printErrorWriter);
                    throw e;
                }
            }
        }
        catch (BadInvOrderException e1) {
            this._isDirty = true;
            throw e1;
        }
        catch (CommunicationException e2) {
            this._isDirty = true;
            throw e2;
        }
        catch (IMSTOCResourceException e3) {
            this._isDirty = true;
            throw e3;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void commit() throws HeuristicMixed, HeuristicHazard, NotPrepared, HeuristicRollback {
        String methodName = String.valueOf(super.toString()) + ".commit()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        String errMsg = this._res.getString("0003E", new Object[]{methodName});
        ResourceException e = new ResourceException(errMsg);
        if (rasService.getTraceLevel() >= 2) {
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            rasService.logTraceInfo(e.toString());
            e.printStackTrace(printTraceWriter);
        }
        PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
        rasService.logError(e.toString());
        e.printStackTrace(printErrorWriter);
        throw e;
    }

    public void commitOnePhase() throws HeuristicHazard, TransactionRolledBack, IMSTOCResourceException {
        String methodName = String.valueOf(super.toString()) + ".commitOnePhase()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._coordinationID = null;
        if (this._isDirty) {
            String errMsg = this._res.getString("0004E", new Object[]{methodName});
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                errMsg = String.valueOf(errMsg) + " " + this._res.getString("0010E", new Object[]{methodName, ex});
            }
            TransactionRolledBack e = new TransactionRolledBack(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            IMSAdapter oIMSAdapter = this.getIMSAdapter();
            oIMSAdapter.getSyncLevel();
            IMSAPIState imsAPIState = oIMSAdapter.getIMSAPIState();
            if (imsAPIState.getState() == 3 || imsAPIState.getState() == 5) {
                oIMSAdapter.sendAck();
                if (oIMSAdapter.getCommitMode() == 1) {
                    oIMSAdapter.receive(this._InteractionSpec);
                }
            }
            this._coordinationID = null;
        }
        catch (CommunicationException e1) {
            this._isDirty = true;
            String errMsg = this._res.getString("0007E", new Object[]{methodName, e1});
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            TransactionRolledBack e = new TransactionRolledBack(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                this._res.getString("0010E", new Object[]{methodName, ex});
                if (rasService.getTraceLevel() >= 2) {
                    rasService.logTraceInfo(ex.toString());
                    ex.printStackTrace(printTraceWriter);
                }
                rasService.logError(ex.toString());
                ex.printStackTrace(printErrorWriter);
            }
            throw e;
        }
        catch (BadInvOrderException e2) {
            this._isDirty = true;
            String errMsg = this._res.getString("0007E", new Object[]{methodName, e2});
            TransactionRolledBack e = new TransactionRolledBack(errMsg);
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            if (rasService.getTraceLevel() >= 2) {
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                this._res.getString("0010E", new Object[]{methodName, ex});
                if (rasService.getTraceLevel() >= 2) {
                    rasService.logTraceInfo(ex.toString());
                    ex.printStackTrace(printTraceWriter);
                }
                rasService.logError(ex.toString());
                ex.printStackTrace(printErrorWriter);
            }
            throw e;
        }
        catch (IMSTOCResourceException e3) {
            this._isDirty = true;
            String errMsg = this._res.getString("0007E", new Object[]{methodName, e3});
            TransactionRolledBack e = new TransactionRolledBack(errMsg);
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            if (rasService.getTraceLevel() >= 2) {
                rasService.logTraceInfo(e.toString());
                ((Throwable)((Object)e3)).printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            ((Throwable)((Object)e3)).printStackTrace(printErrorWriter);
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                this._res.getString("0010E", new Object[]{methodName, ex});
                if (rasService.getTraceLevel() >= 2) {
                    rasService.logTraceInfo(ex.toString());
                    ex.printStackTrace(printTraceWriter);
                }
                rasService.logError(ex.toString());
                ex.printStackTrace(printErrorWriter);
            }
            throw e;
        }
        catch (ResourceException e4) {
            this._isDirty = true;
            String errMsg = this._res.getString("0007E", new Object[]{methodName, e4});
            TransactionRolledBack e = new TransactionRolledBack(errMsg);
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            if (rasService.getTraceLevel() >= 2) {
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                this._res.getString("0010E", new Object[]{methodName, ex});
                if (rasService.getTraceLevel() >= 2) {
                    rasService.logTraceInfo(ex.toString());
                    ex.printStackTrace(printTraceWriter);
                }
                rasService.logError(ex.toString());
                ex.printStackTrace(printErrorWriter);
            }
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void connect() throws AlreadyConnectedException, CommunicationException, BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".connect()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        IMSAdapter oIMSAdapter = this.getIMSAdapter();
        IMSLogonInfoItems logonInfoItems = new IMSLogonInfoItems(runtimeContext.getLogonInfo());
        String userID = logonInfoItems.getUser();
        String password = logonInfoItems.getPassword();
        String group = logonInfoItems.getGroup();
        if (userID != null) {
            oIMSAdapter.setUserID(userID);
        }
        if (password != null) {
            oIMSAdapter.setPassword(password);
        }
        if (group != null) {
            oIMSAdapter.setGroupName(group);
        }
        oIMSAdapter.setConnectionSpec((IMSConnectionSpec)this.getConnectionSpec());
        try {
            Coordinator coordinator;
            if (!oIMSAdapter.isConnected()) {
                oIMSAdapter.connect();
                this._isDirty = false;
            }
            if ((coordinator = runtimeContext.getCoordinator()).isCoordinating() && this._coordinationID == null) {
                coordinator.register((Resource)this);
                this._coordinationID = coordinator.getCoordinationID();
            }
        }
        catch (BadInvOrderException e1) {
            this._isDirty = true;
            throw e1;
        }
        catch (CommunicationException e2) {
            this._isDirty = true;
            throw e2;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void destroyManaged() {
        String methodName = String.valueOf(super.toString()) + ".destroyManaged()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        this._isInUse = false;
        if (this._coordinationID != null) {
            this.disconnect();
        }
    }

    public void disconnect() {
        String methodName = String.valueOf(super.toString()) + ".disconnect()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            if (this.getIMSAdapter().isConnected()) {
                this.getIMSAdapter().disconnect();
            }
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo(String.valueOf(methodName) + " >>> connection closed");
            }
        }
        catch (CommunicationException e1) {
            this._isDirty = true;
            throw e1;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
    }

    public void forget() {
        String methodName = String.valueOf(super.toString()) + ".forget()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
    }

    public ConnectionSpec getConnectionSpec() {
        String methodName = String.valueOf(super.toString()) + ".getConnectionSpec()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._ConnectionSpec;
    }

    public Identifier getCoordinationID() {
        String methodName = String.valueOf(super.toString()) + ".getCoordinationID()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._coordinationID;
    }

    public IMSAdapter getIMSAdapter() {
        String methodName = String.valueOf(super.toString()) + ".getIMSAdapter()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        if (this._IMSAdapter == null) {
            this._IMSAdapter = new IMSAdapter();
        }
        return this._IMSAdapter;
    }

    public Object getXAResource() {
        String methodName = String.valueOf(super.toString()) + ".getXAResource()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return null;
    }

    public boolean isDirty() {
        String methodName = String.valueOf(super.toString()) + ".isDirty()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._isDirty;
    }

    public boolean isInUse() {
        String methodName = String.valueOf(super.toString()) + ".isInUse()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._isInUse;
    }

    public boolean isTwoPhaseCapable() {
        String methodName = String.valueOf(super.toString()) + ".isTwoPhaseCapable()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return false;
    }

    public int prepare() throws HeuristicMixed, HeuristicHazard {
        String methodName = String.valueOf(super.toString()) + ".prepare()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return 0;
    }

    public void prepareManagedForReuse() {
        String methodName = String.valueOf(super.toString()) + ".prepareManagedForReuse()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (this._coordinationID != null) {
            String errMsg = this._res.getString("0006E", new Object[]{methodName});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
    }

    public void rollback() throws HeuristicMixed, HeuristicHazard, HeuristicCommit {
        String methodName = String.valueOf(super.toString()) + ".rollback()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        RASService rasService = runtimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (this._isDirty) {
            this.disconnect();
        } else {
            try {
                IMSAdapter oIMSAdapter = this.getIMSAdapter();
                IMSAPIState imsAPIState = oIMSAdapter.getIMSAPIState();
                if (imsAPIState.getState() == 3 || imsAPIState.getState() == 5) {
                    oIMSAdapter.sendNack();
                    if (oIMSAdapter.getCommitMode() == 1) {
                        oIMSAdapter.receive(this._InteractionSpec);
                        oIMSAdapter.sendAck();
                        oIMSAdapter.receive(this._InteractionSpec);
                    }
                }
                this._coordinationID = null;
            }
            catch (BadInvOrderException e1) {
                this._isDirty = true;
                try {
                    this.disconnect();
                }
                catch (Exception ex) {
                    this._res.getString("0010E", new Object[]{methodName, ex});
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(ex.toString());
                        ex.printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(ex.toString());
                    ex.printStackTrace(printErrorWriter);
                }
                throw e1;
            }
            catch (CommunicationException e2) {
                this._isDirty = true;
                try {
                    this.disconnect();
                }
                catch (Exception ex) {
                    this._res.getString("0010E", new Object[]{methodName, ex});
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(ex.toString());
                        ex.printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(ex.toString());
                    ex.printStackTrace(printErrorWriter);
                }
                throw e2;
            }
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        String methodName = String.valueOf(super.toString()) + ".setConnectionSpec(ConnectionSpec)";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        this._ConnectionSpec = (IMSConnectionSpec)connectionSpec;
    }

    public void setCoordinationID(Identifier id) {
        String methodName = String.valueOf(super.toString()) + ".setCoordinationID(Identifier)";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        this._coordinationID = id;
    }

    public void start() {
        String methodName = String.valueOf(super.toString()) + ".start()";
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        if (runtimeContext.getRASService().getTraceLevel() >= 2) {
            runtimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
    }

    public String toString() {
        RuntimeContext runtimeContext = RuntimeContext.getCurrent();
        return "\t[" + super.toString() + "]" + "\n\t\t\truntimeContext: [" + runtimeContext + "]" + "\n\t\t\tconnectionSpec: [" + this._ConnectionSpec + "]" + "\n\t\t\tinteractionSpec: [" + this._InteractionSpec + "]" + "\n\t\t\tlogonInfoItems: [" + (Object)((Object)new IMSLogonInfoItems(runtimeContext.getLogonInfo())) + "]" + "\n\t\t\tisInUse: [" + this._isInUse + "]" + "\n\t\t\tisDirty: [" + this._isDirty + "]" + "\n\t\t\tcoordinationID: [" + this._coordinationID + "]" + "\n\t\t\tIMSAdpater: [" + this._IMSAdapter + "\n\t\t\t]";
    }
}

