-- -----------------------------------------------------------
--
--  IBM(R) VisualAge(TM) for Java(TM) Version 1 and others
--   - Licensed Material - Program-Property of IBM
--  (C) Copyright IBM Corp. 1997 - All Rights Reserved.
--  US Government Users Restricted Rights - Use, duplication or disclosure
--  restricted by GSA ADP Schedule Contract with IBM Corp.
--
-- -----------------------------------------------------------

--
-- This template generates the BeanInfo classes.
--

POBeanInfo()
{
  Sub class
  Counter index(0,1), mindex(0,1), argCounter(0,1)

  index|reset()
  mindex|reset()
 /*$package()$

import java.beans.*;
import java.math.*;
import java.sql.*;
import COM.ibm.ivj.eab.data.*;

public class $class->name$BeanInfo extends SimpleBeanInfo
{
  public $class->name$BeanInfo() {
    if (!flag) {
      addProperties();
      addMethods();
      initBeanDescriptor();
      flag = true;
    }
  }

  private static void addProperties() {
    try { */

-- *** static properties are not supported yet ***
--      _pDesc[$index$] = new PropertyDescriptor("defaultDatastore", $class->name$.class);
--      _pDesc[$index$].setShortDescription(DAResource.getBeanText("DEFDSM_DESC"));
--      _pDesc[$index$].setDisplayName(DAResource.getBeanText("DEFDSM_NAME"));*/ endl
-- index|increment() /*
--      _pDesc[$index$] = new PropertyDescriptor("qualifier", $class->name$.class);
--      _pDesc[$index$].setShortDescription(DAResource.getBeanText("QUAL_DESC"));
--      _pDesc[$index$].setDisplayName(DAResource.getBeanText("QUAL_NAME")); */ endl
-- index|increment()
-- ***********************************************

 if (class->genDataId) {
  /*
      _pDesc[$index$] = new PropertyDescriptor("dataId", $class->name$.class);
      _pDesc[$index$].setShortDescription(DAResource.getBeanText("DATAID_DESC"));
      _pDesc[$index$].setDisplayName(DAResource.getBeanText("DATAID_NAME"));
      _pDesc[$index$].setBound(true); */ endl
  index|increment()
 }

 repeat(class->attr) {
   describeAttr(&attr, class->name, index)
   index|increment()  /*
      _pDesc[$index$] = new PropertyDescriptor("$attr->name$Nullable", $class->name$.class, "is$attr->Name$Nullable", null ); */ endl
   index|increment()
 }

   /*
    } catch (Exception e) {}
  }

  private static void addMethods() {
    ParameterDescriptor parms[] = null;
    try {
      if (_mDesc.length == 0) return; */ endl
    if (class->genUpdateDataId && class->genDataId) {
      /*
      // ***update($class->name$DataId)***
      parms = new ParameterDescriptor[1];

      parms[0] = new ParameterDescriptor();
      parms[0].setDisplayName("aDataId");
      parms[0].setName("arg1");

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("update",
                                              new Class[] { $class->name$DataId.class } ), parms);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("UPDATEID_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("UPDATEID_NAME")); */ endl endl
      mindex|increment()
    }
    if (class->genUpdateDataId && class->genDataId && (!class->allDataIds) ) {
      /*
      // ***update()***
      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("update", null), null);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("UPDATE_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("UPDATE_NAME")); */ endl endl
      mindex|increment()
    }

    repeat(class->userMethod) {
      describeMethod(&userMethod, userMethod->name, userMethod->displayName, class->name, &mindex)
      mindex|increment()
    }

    /*
    // add get/set methods */ endl
    repeat(class->attr) {
      describeAttrMethods(&attr, class->name, &mindex)
      /*      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("is$attr->Name$Nullable", null), null); */ endl
      mindex|increment()
    }

    /*
      // qualifier
      parms = new ParameterDescriptor[1];

      parms[0] = new ParameterDescriptor();
      parms[0].setDisplayName(DAResource.getBeanText("QUAL_NAME"));
      parms[0].setName("qualifier");

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("setQualifier", new Class[] { String.class }), parms);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("SETQUAL_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("SETQUAL_NAME")); */ mindex|increment() /*

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("getQualifier", null), null);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("GETQUAL_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("GETQUAL_NAME"));

      // default datastore
      parms = new ParameterDescriptor[1];

      parms[0] = new ParameterDescriptor();
      parms[0].setDisplayName(DAResource.getBeanText("ADSM_NAME"));
      parms[0].setName("aDSM"); */ mindex|increment() /*

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("setDefaultDatastore", new Class[] { DatastoreJDBC.class }), parms);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("SETDEFDSM_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("SETDEFDSM_NAME")); */ mindex|increment() /*

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("getDefaultDatastore", null), null);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("GETDEFDSM_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("GETDEFDSM_NAME")); */ endl

      if (class->genDataId) {
       /*
      // dataId
      parms = new ParameterDescriptor[1];

      parms[0] = new ParameterDescriptor();
      parms[0].setDisplayName(DAResource.getBeanText("ADATAID_NAME"));
      parms[0].setName("aDataId"); */ mindex|increment() /*

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("setDataId", new Class[] { $class->name$DataId.class }), parms);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("SETDATAID_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("SETDATAID_NAME")); */ mindex|increment() /*

      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("getDataId", null), null);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("GETDATAID_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("GETDATAID_NAME")); */ endl
      }

      mindex|increment() /*
    } catch(Exception e) {}
  }

  private static void initBeanDescriptor() {
    _descriptor.setShortDescription("$shortDesc(class->comment)$");
  }

  public PropertyDescriptor[] getPropertyDescriptors() { return _pDesc; }
  public MethodDescriptor[] getMethodDescriptors() { return _mDesc; }

  public BeanInfo[] getAdditionalBeanInfo() {
    BeanInfo ret[] = new BeanInfo[1];
    ret[0] = new PersistentObjectBeanInfo();
    return ret;
  }

  public java.awt.Image getIcon(int iconKind) {
    if (iconKind == BeanInfo.ICON_COLOR_16x16) {
      java.awt.Image img = loadImage("PersistentObjectColor16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_COLOR_32x32) {
      java.awt.Image img = loadImage("PersistentObjectColor32.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_16x16) {
      java.awt.Image img = loadImage("PersistentObjectMono16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_32x32) {
      java.awt.Image img = loadImage("PersistentObjectMono32.gif");
      return img;
    }
    return null;
  }

  public static String getGifFile () {
    return "PersistentObject.gif";
  }

  public BeanDescriptor getBeanDescriptor() { return _descriptor; }

  private static PropertyDescriptor _pDesc[] = new PropertyDescriptor[$index$];
  private static MethodDescriptor _mDesc[] = new MethodDescriptor[$mindex$];
  private static BeanDescriptor _descriptor = new BeanDescriptor($class->name$.class);
  private static boolean flag = false;
} */ endl

}

DataIdBeanInfo()
{
  Sub class
  Counter index(0,1), mindex(0,1)

  index|reset() mindex|reset()
 /*$package()$

import java.beans.*;
import java.math.*;
import java.sql.*;
import COM.ibm.ivj.eab.data.*;

public class $class->name$DataIdBeanInfo extends SimpleBeanInfo
{
  public $class->name$DataIdBeanInfo() {
    if (!flag) {
      addProperties();
      addMethods();
      initBeanDescriptor();
      flag = true;
    }
  }

  private static void addProperties() {
    try {*/ endl

 repeat(class->attr | condition(attr->isDataId) ) {
   describeAttr(&attr, class->name + "DataId", index)
   index|increment()  /*
      _pDesc[$index$] = new PropertyDescriptor("$attr->name$Nullable", $class->name$DataId.class, "is$attr->Name$Nullable", null ); */ endl
   index|increment()
 }

  /*
    } catch(Exception e) {}
  }

  private static void addMethods() {
    ParameterDescriptor parms[] = null;
    try {*/ endl

 repeat(class->attr | condition(attr->isDataId) ) {
   describeAttrMethods(&attr, class->name + "DataId", &mindex)
   /*      _mDesc[$mindex$] = new MethodDescriptor($class->name$.class.getMethod("is$attr->Name$Nullable", null), null); */ endl
   mindex|increment()
 }

  /*
    } catch(Exception e) {}
  }


  public PropertyDescriptor[] getPropertyDescriptors() { return _pDesc; }

  public MethodDescriptor[] getMethodDescriptors() { return _mDesc; }

  public BeanInfo[] getAdditionalBeanInfo() {
    BeanInfo ret[] = new BeanInfo[1];
    ret[0] = new PODataIdBeanInfo();
    return ret;
  }

  public java.awt.Image getIcon(int iconKind) {
    if (iconKind == BeanInfo.ICON_COLOR_16x16) {
      java.awt.Image img = loadImage("PODataIdColor16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_COLOR_32x32) {
      java.awt.Image img = loadImage("PODataIdColor32.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_16x16) {
      java.awt.Image img = loadImage("PODataIdMono16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_32x32) {
      java.awt.Image img = loadImage("PODataIdMono32.gif");
      return img;
    }
    return null;
  }

  public static String getGifFile () {
    return "PODataId.gif";
  }

  public BeanDescriptor getBeanDescriptor() { return _descriptor; }

  private static void initBeanDescriptor() {
    _descriptor.setShortDescription("Data Identifier for the $class->name$ class");
  }

  private static BeanDescriptor _descriptor = new BeanDescriptor($class->name$DataId.class);
  private static PropertyDescriptor _pDesc[] = new PropertyDescriptor[$index$];
  private static MethodDescriptor _mDesc[] = new MethodDescriptor[$mindex$];
  private static boolean flag=false;

} */ endl

}

DatastoreBeanInfo()
{
  Sub class
  Counter index(0,1)

  index|reset()
 /*$package()$

import java.beans.*;
import COM.ibm.ivj.eab.data.*;

public class $class->name$DatastoreBeanInfo extends SimpleBeanInfo
{
  public $class->name$DatastoreBeanInfo() {
    if (!flag) {
      addMethods();
      initBeanDescriptor();
      flag = true;
    }
  }

  public BeanInfo[] getAdditionalBeanInfo() {
    BeanInfo ret[] = new BeanInfo[1];
    ret[0] = new DatastoreJDBCBeanInfo();
    return ret;
  }

  private static void addMethods() {
    try {
      _mDesc[0] = new MethodDescriptor($class->name$Datastore.class.getMethod("setAsDefaultDatastore", null), null);
      _mDesc[0].setShortDescription(DAResource.getBeanText("SETASDEFDSM_DESC"));
      _mDesc[0].setDisplayName(DAResource.getBeanText("SETASDEFDSM_NAME"));
    } catch(Exception e) {}
  }

  public java.awt.Image getIcon(int iconKind) {
    if (iconKind == BeanInfo.ICON_COLOR_16x16) {
      java.awt.Image img = loadImage("DatastoreJDBCColor16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_COLOR_32x32) {
      java.awt.Image img = loadImage("DatastoreJDBCColor32.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_16x16) {
      java.awt.Image img = loadImage("DatastoreJDBCMono16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_32x32) {
      java.awt.Image img = loadImage("DatastoreJDBCMono32.gif");
      return img;
    }
    return null;
  }

  public static String getGifFile () {
    return "DatastoreJDBC.gif";
  }

  public MethodDescriptor[] getMethodDescriptors() { return _mDesc; }
  public BeanDescriptor getBeanDescriptor() { return _descriptor; }

  private static void initBeanDescriptor() {
    _descriptor.setShortDescription("Connects by default to datastore: '$class->URLName$'");
  }

  private static BeanDescriptor _descriptor = new BeanDescriptor($class->name$Datastore.class);
  private static MethodDescriptor _mDesc[] = new MethodDescriptor[1];
  private static boolean flag = false;
} */ endl

}



ManagerBeanInfo()
{
  Sub class
  mngrBeanInfo("", &class->pdqMethod, &class->mSpcMethod)
}

DataIdManagerBeanInfo()
{
  Sub class
  mngrBeanInfo("DataId", &class->pdqMethod, &class->mSpcMethod)
}

mngrBeanInfo(DataId, pdqMethod, mSpcMethod)
{
  Sub class
  Counter mindex(0,1), index(1,1)
  Var CLASSNAME, ICON


  if (DataId == "") ICON = "DAManager"
  else ICON = "DataIdManager"

  CLASSNAME = class->name + DataId
  mindex|reset()
  index|reset()

 /*$package()$

import java.beans.*;
import java.math.*;
import java.sql.*;
import COM.ibm.ivj.eab.data.*;

public class $CLASSNAME$ManagerBeanInfo extends SimpleBeanInfo
{
  public $CLASSNAME$ManagerBeanInfo() {
    if (!flag) {
      addProperties();
      addMethods();
      initBeanDescriptor();
      flag = true;
    }
  }

  private static void addProperties() {
    try {
      _pDesc[0] = new PropertyDescriptor("element", $CLASSNAME$Manager.class, "element", null );
      _pDesc[0].setShortDescription(DAResource.getBeanText("ELEMENT_DESC"));
      _pDesc[0].setDisplayName(DAResource.getBeanText("ELEMENT_NAME")); */ endl

  if (class->hasMngrAttr) {
    repeat(class->mngrAttr) {
      describeAttr(&mngrAttr, CLASSNAME + "Manager", index)
      index|increment() endl
    }
  }

   /*    } catch(Exception e) {}
  }

  private static void addMethods() {
    ParameterDescriptor parms[] = null;
    try {
      if (_mDesc.length == 0) return; */ endl endl

    repeat(pdqMethod) {
      describeMethod(&pdqMethod->ELEMENT, "open" + pdqMethod->name, "open" + pdqMethod->displayName,
                     CLASSNAME + "Manager", &mindex)
      mindex|increment()
      describeMethod(&pdqMethod->ELEMENT, "select" + pdqMethod->name, "select" + pdqMethod->displayName,
                     CLASSNAME + "Manager", &mindex)
      mindex|increment()
    }

    repeat(mSpcMethod) {
      describeMethod(&mSpcMethod->ELEMENT, "open" + mSpcMethod->name, "open" + mSpcMethod->displayName,
                     CLASSNAME + "Manager", &mindex)
      mindex|increment()
      describeMethod(&mSpcMethod->ELEMENT, "select" + mSpcMethod->name, "select" + mSpcMethod->displayName,
                     CLASSNAME + "Manager", &mindex)
      mindex|increment()
    }

    repeat(class->mngrAttr) {
      describeAttrMethods(&mngrAttr, CLASSNAME + "Manager", &mindex)
    }
    /*
      _mDesc[$mindex$] = new MethodDescriptor($CLASSNAME$Manager.class.getMethod("element", null), null);
      _mDesc[$mindex$].setShortDescription(DAResource.getBeanText("ELEMENT_DESC"));
      _mDesc[$mindex$].setDisplayName(DAResource.getBeanText("ELEMENT_NAME")); */ mindex|increment() /*

    } catch(Exception e) {}
  }

  public PropertyDescriptor[] getPropertyDescriptors() { return _pDesc; }
  public MethodDescriptor[] getMethodDescriptors() { return _mDesc; }

  public BeanInfo[] getAdditionalBeanInfo() {
    BeanInfo ret[] = new BeanInfo[1];
    ret[0] = new DAManagerBeanInfo();
    return ret;
  }

  public java.awt.Image getIcon(int iconKind) {
    if (iconKind == BeanInfo.ICON_COLOR_16x16) {
      java.awt.Image img = loadImage("$ICON$Color16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_COLOR_32x32) {
      java.awt.Image img = loadImage("$ICON$Color32.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_16x16) {
      java.awt.Image img = loadImage("$ICON$Mono16.gif");
      return img;
    }
    if (iconKind == BeanInfo.ICON_MONO_32x32) {
      java.awt.Image img = loadImage("$ICON$Mono32.gif");
      return img;
    }
    return null;
  }

  public static String getGifFile () {
    return "$ICON$.gif";
  }

  public BeanDescriptor getBeanDescriptor() { return _descriptor; }

  private static void initBeanDescriptor() {
    _descriptor.setShortDescription("Manager class for $CLASSNAME$ objects.");
  }

  private static BeanDescriptor _descriptor = new BeanDescriptor($CLASSNAME$Manager.class);
  private static PropertyDescriptor _pDesc[] = new PropertyDescriptor[$index$];
  private static MethodDescriptor _mDesc[] = new MethodDescriptor[$mindex$];
  private static boolean flag=false;

} */ endl


}

shortDesc(comment)
{
  comment|change("\r\n","\n")|change("\n"," ")|change("\r"," ")|change("\t", " ")|subString(1,40)|strip()
}

describeAttr(attr, className, index)
{
  /*
      _pDesc[$index$] = new PropertyDescriptor("$attr->name$", $className$.class);
      _pDesc[$index$].setShortDescription("$shortDesc(&attr->shortDesc)$");
      _pDesc[$index$].setDisplayName("$attr->displayName$");
      _pDesc[$index$].setBound(true);*/

  if (attr->type == "java.sql.Date") { /*
      _pDesc[$index$].setPropertyEditorClass(DateEditor.class); */
  } else if (attr->type == "Time") { /*
      _pDesc[$index$].setPropertyEditorClass(TimeEditor.class); */
  } else if (attr->type == "Timestamp") { /*
      _pDesc[$index$].setPropertyEditorClass(TimestampEditor.class); */
  } else if (attr->type == "BigDecimal") { /*
      _pDesc[$index$].setPropertyEditorClass(COM.ibm.ivj.eab.data.BigDecimalEditor.class); */
  } else if (attr->type == "DAIOStream") { /*
      _pDesc[$index$].setPropertyEditorClass(DAIOStreamEditor.class); */
  }
}

describeMethod(method, methodName, displayName, className, index)
{
  Counter argCounter(0,1)

  argCounter|reset()
  -- count arguments
  repeat (method->arg | condition(arg->isParameter) ) argCounter|increment()

  /*
     // ***$methodName$*** */
  if (argCounter != "0") {
    /*
      parms = new ParameterDescriptor[$argCounter$];*/  endl
    argCounter|reset()
    repeat (method->arg | condition(arg->isParameter) ) {
      /*      parms[$argCounter$] = new ParameterDescriptor(); */ endl
      /*      parms[$argCounter$].setDisplayName("$arg->name$"); */ endl
      /*      parms[$argCounter$].setName(*/ argCounter|increment() /*"arg$argCounter$"); */ endl
    }

    /*      _mDesc[$index$] = new MethodDescriptor($className$.class.getMethod("$methodName$",
                                             new Class[] {*/
    repeat( method->arg | condition(arg->isParameter) middle /*, */ ) {
      if (arg->isOutput || arg->isResultCol) { /*$arg->type$[].class*/ }
      else { /*$arg->type$.class*/ }
    }
    /*} ), parms);  */
  } else { /*
      _mDesc[$index$] = new MethodDescriptor($className$.class.getMethod("$methodName$", null ), null);  */
  }

  /*
      _mDesc[$index$].setShortDescription("$shortDesc(&method->comment)$");
      _mDesc[$index$].setDisplayName("$displayName$"); */ endl

}

describeAttrMethods(attr, className, index)
{
  /*
      parms = new ParameterDescriptor[1];
      parms[0] = new ParameterDescriptor();
      parms[0].setDisplayName("a$attr->Name$");
      parms[0].setName("a$attr->Name$");

      _mDesc[$index$] = new MethodDescriptor($className$.class.getMethod("set$attr->Name$", new Class[] { $attr->type$.class } ), parms);  */
  index|increment() /*
      _mDesc[$index$] = new MethodDescriptor($className$.class.getMethod("get$attr->Name$", null), null); */ endl
  index|increment()

}

