/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.grid.view.JKRepairPolicy;
import com.objectshare.grid.view.JKTableView;

public class JKRollingRepairPolicy
extends JKRepairPolicy
implements Runnable {
    public static int defaultRollingRepairDelay = 100;
    public static int defaultAbsoluteRepairDelay = 500;
    protected int rollingRepairDelay;
    protected int absoluteRepairDelay;
    protected transient long firstDamageTime;
    protected transient long lastDamageTime;
    protected transient Thread repairThread;

    public JKRollingRepairPolicy(JKTableView jKTableView) {
        this(jKTableView, defaultRollingRepairDelay, defaultAbsoluteRepairDelay);
    }

    public JKRollingRepairPolicy(JKTableView jKTableView, int n, int n2) {
        super(jKTableView);
        this.rollingRepairDelay = n;
        this.absoluteRepairDelay = n2;
    }

    public synchronized void damaged() {
        if (this.isActive()) {
            long l = System.currentTimeMillis();
            if (this.firstDamageTime == 0L) {
                this.firstDamageTime = l;
            }
            this.notify();
        }
    }

    public synchronized void repairDamage() {
        this.lastDamageTime = 0L;
        this.firstDamageTime = 0L;
        super.repairDamage();
    }

    public synchronized void start() {
        if (this.repairThread == null) {
            this.repairThread = new Thread(this);
            this.repairThread.start();
        }
    }

    public synchronized void stop() {
        if (this.repairThread != null) {
            this.repairThread.stop();
            this.repairThread = null;
        }
    }

    public boolean isActive() {
        return this.repairThread != null;
    }

    protected synchronized long getSleepTime() {
        long l = this.lastDamageTime + (long)this.rollingRepairDelay;
        long l2 = this.firstDamageTime + (long)this.absoluteRepairDelay;
        long l3 = l < l2 ? l : l2;
        return l3 - System.currentTimeMillis();
    }

    protected synchronized void waitForDamage() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        long l = this.getSleepTime();
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
            l = this.getSleepTime();
        }
    }

    public void run() {
        while (true) {
            this.waitForDamage();
            this.repairDamage();
        }
    }
}

