/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;
import java.awt.Rectangle;

public abstract class JKTableSelectTool
extends JKTableTool {
    public static boolean defaultToggleSelect;
    public transient JKTableArea originalSelection;
    public int anchorX = 0;
    public int anchorY = 0;
    public boolean keepEditorOpen = false;
    public boolean toggleSelect = defaultToggleSelect;

    public JKTableSelectTool() {
        this.originalSelection = JKTableArea.empty;
    }

    public boolean getToggleSelect() {
        return this.toggleSelect;
    }

    public void setToggleSelect(boolean bl) {
        this.toggleSelect = bl;
    }

    public void mouseDrag(Event event) {
        this.dragSelect(event);
        this.autoScroll(event);
    }

    public void mouseUp(Event event) {
        this.dragSelect(event);
        this.selectionChanged(this.owner.selection);
        this.originalSelection = null;
        super.mouseUp(event);
    }

    public boolean keyboardEvent(Event event, JKTableArea jKTableArea) {
        JKTableArea jKTableArea2;
        if (event.id == 403 && (jKTableArea2 = this.nextSelection(jKTableArea, event)) != null) {
            this.setSelection(jKTableArea2);
            return true;
        }
        return false;
    }

    protected boolean setupSelection(JKTableArea jKTableArea) {
        if (!this.keepEditorOpen && !this.owner.closeEditor()) {
            return false;
        }
        if (this.originalSelection == null) {
            this.originalSelection = this.owner.selection;
        }
        this.owner.mouseDragAction = this;
        this.owner.mouseUpAction = this;
        this.selectionChanging(jKTableArea);
        return true;
    }

    protected void selectionChanging(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.owner.selection;
        if (!jKTableArea2.equals(jKTableArea)) {
            this.owner.selection(this.owner.triggerSelecting(jKTableArea2, jKTableArea));
        }
    }

    protected void selectionChanged(JKTableArea jKTableArea) {
        if (!this.originalSelection.equals(jKTableArea)) {
            this.owner.selection(jKTableArea);
            this.owner.triggerSelected(this.originalSelection, jKTableArea);
        }
    }

    protected void setSelection(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.owner.selection;
        if (!jKTableArea2.equals(jKTableArea)) {
            this.owner.selection(this.owner.triggerSelecting(jKTableArea2, jKTableArea));
            this.owner.triggerSelected(jKTableArea2, jKTableArea);
        }
    }

    protected JKTableArea nextSelection(JKTableArea jKTableArea, Event event) {
        return null;
    }

    public void dragSelect(Event event) {
    }

    public void autoScroll(Event event) {
        Rectangle rectangle = this.adapter.getScreenBounds();
        int n = 0;
        int n2 = 0;
        if (event.x < rectangle.x) {
            n = event.x - rectangle.x;
        }
        if (event.y < rectangle.y) {
            n2 = event.y - rectangle.y;
        }
        if (event.x >= rectangle.x + rectangle.width) {
            n = event.x - rectangle.x - rectangle.width;
        }
        if (event.y >= rectangle.y + rectangle.height) {
            n2 = event.y - rectangle.y - rectangle.height;
        }
        if (n != 0 || n2 != 0) {
            this.owner.getCoordinator().setVirtualScroll(this.adapter.adapterX, this.adapter.adapterY, this.adapter.getVirtualScroll().x + n, this.adapter.getVirtualScroll().y + n2);
        }
    }
}

