/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntVector;
import com.objectshare.grid.area.JKRowArea;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKSortException;
import com.objectshare.grid.tool.JKSortedObject;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class JKSortTool
extends JKTableTool {
    protected boolean alternateSort;
    public int lastColumnSorted = Integer.MIN_VALUE;
    int cellX;
    int cellY;
    public static boolean defaultAlternateSort = true;

    public JKSortTool() {
        this.alternateSort = defaultAlternateSort;
    }

    public JKSortTool(boolean bl) {
        this.alternateSort = bl;
    }

    public JKSortTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        this(jKTableList, jKTableListAdapter, defaultAlternateSort);
    }

    public JKSortTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, boolean bl) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
        this.alternateSort = bl;
    }

    public boolean getAlternateSort() {
        return this.alternateSort;
    }

    public void setAlternateSort(boolean bl) {
        this.alternateSort = bl;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.getIgnoreClickCount() && event.clickCount > 1) {
            return false;
        }
        this.cellX = n;
        this.cellY = n2;
        this.owner.mouseDragAction = this;
        this.owner.mouseUpAction = this;
        return true;
    }

    public void mouseUp(Event event) {
        Point point = this.owner.cellForPoint(event.x, event.y);
        if (point != null && point.x == this.cellX && point.y == this.cellY && this.owner.closeEditor()) {
            boolean bl;
            JKTableArea jKTableArea;
            JKTableArea jKTableArea2 = jKTableArea = event.controlDown() ? this.owner.selection : JKTableArea.newForRows(1, this.owner.data.getNumberOfRows());
            if (this.alternateSort) {
                if (this.lastColumnSorted == this.cellX) {
                    this.lastColumnSorted = Integer.MIN_VALUE;
                    bl = true;
                } else {
                    this.lastColumnSorted = this.cellX;
                    bl = false;
                }
            } else {
                bl = event.shiftDown();
            }
            this.sort(jKTableArea, this.cellX, bl);
        }
        this.owner.mouseDragAction = null;
        this.owner.mouseUpAction = null;
    }

    public void sort(JKTableArea jKTableArea, int n, boolean bl) {
        Enumeration enumeration;
        int n2;
        Vector<OSIIntVector> vector = new Vector<OSIIntVector>();
        OSIEnumeration oSIEnumeration = jKTableArea.elements();
        int n3 = this.owner.data.getNumberOfRows();
        int n4 = -1;
        while (oSIEnumeration.hasMoreElements()) {
            Object e = oSIEnumeration.nextElement();
            if (!(e instanceof JKRowArea)) continue;
            int n5 = ((JKRowArea)e).y;
            n2 = n5 + ((JKRowArea)e).height;
            if (n3 > n5) {
                n3 = n5;
            }
            if (n4 < n2 - 1) {
                n4 = n2 - 1;
            }
            while (n5 < n2) {
                enumeration = vector.elements();
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        if (enumeration.hasMoreElements()) {
                            this.sortRow(n5, n, (OSIIntVector)enumeration.nextElement());
                        } else {
                            OSIIntVector oSIIntVector = new OSIIntVector();
                            oSIIntVector.add(n5);
                            vector.addElement(oSIIntVector);
                        }
                        bl2 = true;
                    }
                    catch (JKSortException jKSortException) {}
                }
                ++n5;
            }
        }
        if (n3 <= n4) {
            int n6 = n4 - n3 + 1;
            int[] nArray = new int[n6];
            n2 = 0;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                OSIIntVector oSIIntVector = (OSIIntVector)enumeration.nextElement();
                int n7 = 0;
                while (n7 < oSIIntVector.size) {
                    nArray[n2++] = oSIIntVector.get(n7++);
                }
            }
            if (n2 < n6) {
                int n8 = n3;
                while (n8 <= n4) {
                    int n9 = 0;
                    while (n9 < n2 && nArray[n9] != n8) {
                        ++n9;
                    }
                    if (n9 == n2) {
                        nArray[n2++] = n8;
                    }
                    ++n8;
                }
            }
            if (bl) {
                int[] nArray2 = new int[nArray.length];
                n2 = 0;
                while (n2 < nArray.length) {
                    nArray2[n2] = nArray[nArray.length - n2 - 1];
                    ++n2;
                }
                nArray = nArray2;
            }
            this.owner.getModel().reorderRows(n3, nArray);
        }
    }

    public void sortRow(int n, int n2, OSIIntVector oSIIntVector) throws JKSortException {
        Object object = this.owner.getModel().get(n, n2);
        int n3 = oSIIntVector.size;
        if (n3 < 1) {
            oSIIntVector.add(n);
            return;
        }
        Object object2 = this.owner.getModel().get(oSIIntVector.get(n3 - 1), n2);
        if (object instanceof JKSortedObject) {
            if (!(object2 instanceof JKSortedObject)) {
                throw new JKSortException();
            }
            JKSortedObject jKSortedObject = (JKSortedObject)object;
            while (--n3 >= 0) {
                object2 = this.owner.getModel().get(oSIIntVector.get(n3), n2);
                if (jKSortedObject.jkCompareTo(object2) < 0) continue;
                oSIIntVector.insert(n3 + 1, n);
                return;
            }
        } else {
            if (object2 instanceof JKSortedObject) {
                throw new JKSortException();
            }
            String string = object != null ? object.toString() : "";
            while (--n3 >= 0) {
                String string2;
                object2 = this.owner.getModel().get(oSIIntVector.get(n3), n2);
                String string3 = string2 = object2 != null ? object2.toString() : "";
                if (string.compareTo(string2) < 0) continue;
                oSIIntVector.insert(n3 + 1, n);
                return;
            }
        }
        oSIIntVector.insert(0, n);
    }
}

