/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;
import java.awt.Point;
import java.awt.Rectangle;

public class JKReorderCellTool
extends JKTableTool {
    public boolean autoSize;
    protected int eventX;
    protected int eventY;
    protected int startCellX;
    protected int startCellY;
    protected JKTableArea originalSelection;

    public JKReorderCellTool() {
    }

    public JKReorderCellTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        this(jKTableList, jKTableListAdapter, false);
    }

    public JKReorderCellTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, boolean bl) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
        this.autoSize = bl;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.getIgnoreClickCount() && event.clickCount > 1) {
            return false;
        }
        this.eventX = event.x;
        this.eventY = event.y;
        this.startCellX = n;
        this.startCellY = n2;
        this.originalSelection = this.owner.selection;
        JKTableArea jKTableArea = this.dragArea(n, n2);
        if (jKTableArea != null && this.owner.startDrag(this.adapter, jKTableArea, this.dragClip())) {
            this.owner.mouseDragAction = this;
            this.owner.mouseUpAction = this;
            return true;
        }
        return false;
    }

    public void mouseDrag(Event event) {
        this.drag(event.x - this.eventX, event.y - this.eventY);
        this.eventX = event.x;
        this.eventY = event.y;
    }

    public void mouseUp(Event event) {
        this.mouseDrag(event);
        this.owner.endDrag();
        Point point = this.adapter.getCell(event.x, event.y);
        this.reorder(this.startCellX, this.startCellY, point.x, point.y);
        super.mouseUp(event);
    }

    protected JKTableArea dragArea(int n, int n2) {
        return JKTableArea.newForCell(n, n2);
    }

    protected Rectangle dragClip() {
        return this.adapter.getScreenContentBounds();
    }

    protected void drag(int n, int n2) {
        this.owner.drag(n, n2);
    }

    protected void reorder(int n, int n2, int n3, int n4) {
        if (n != n3) {
            this.owner.getModel().moveColumn(n, n3);
        }
        if (n2 != n4) {
            this.owner.getModel().moveRow(n2, n4);
        }
        if (this.autoSize) {
            this.owner.autoSize();
        }
    }
}

