/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.edit.JKEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKCellEditTool;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;
import java.awt.Point;
import java.awt.Rectangle;

public class JKNoWrapTabTool
extends JKCellEditTool {
    protected int[] tabKeys = new int[]{9};

    public int[] getTabKeys() {
        return this.tabKeys;
    }

    public void setTabKeys(int[] nArray) {
        this.tabKeys = nArray;
    }

    public JKNoWrapTabTool() {
    }

    public JKNoWrapTabTool(JKTableTool jKTableTool) {
        super(jKTableTool);
    }

    public JKNoWrapTabTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        super(jKTableList, jKTableListAdapter);
    }

    public JKNoWrapTabTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, int[] nArray) {
        super(jKTableList, jKTableListAdapter);
        this.setTabKeys(nArray);
    }

    public JKNoWrapTabTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, JKTableTool jKTableTool) {
        super(jKTableList, jKTableListAdapter, jKTableTool);
    }

    public JKNoWrapTabTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, JKTableTool jKTableTool, int[] nArray) {
        super(jKTableList, jKTableListAdapter, jKTableTool);
        this.setTabKeys(nArray);
    }

    public boolean isTabKey(int n) {
        int n2 = 0;
        while (n2 < this.tabKeys.length) {
            if (this.tabKeys[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean keyboardEvent(Event event) {
        if (event.id == 401 && this.isTabKey(event.key)) {
            JKTableEdit jKTableEdit = (JKTableEdit)this.owner;
            if (jKTableEdit.editAction != null) {
                Point point = event.shiftDown() ? this.getPreviousCell(jKTableEdit.editAction.dataX, jKTableEdit.editAction.dataY) : this.getNextCell(jKTableEdit.editAction.dataX, jKTableEdit.editAction.dataY);
                if (point == null) {
                    jKTableEdit.closeEditor();
                    return true;
                }
                JKDrawingContext jKDrawingContext = this.owner.getDisplayPolicy().existingCellDrawingContext(point.y, point.x);
                if (JKEditingPolicy.isValid(jKDrawingContext.getEditingPolicy())) {
                    this.showEditor(point.x, point.y);
                    return true;
                }
                return false;
            }
        }
        return super.keyboardEvent(event);
    }

    protected void scroll(JKTableEdit jKTableEdit, int n, int n2) {
        jKTableEdit.keepCellVisible(n2, n);
    }

    protected Point getNextCell(int n, int n2) {
        JKDrawingContext jKDrawingContext;
        Point point = new Point(n, n2);
        do {
            if (this.atEndOfSlice(point)) {
                point = this.getNextWrappedCell(point);
            } else {
                this.moveForward(point);
            }
            if (point != null) continue;
            return null;
        } while (!JKEditingPolicy.isValid((jKDrawingContext = this.owner.getDisplayPolicy().existingCellDrawingContext(point.y, point.x)).getEditingPolicy()));
        return point;
    }

    protected Point getPreviousCell(int n, int n2) {
        JKDrawingContext jKDrawingContext;
        Point point = new Point(n, n2);
        do {
            if (this.atBeginningOfSlice(point)) {
                point = this.getPreviousWrappedCell(point);
            } else {
                this.moveBack(point);
            }
            if (point != null) continue;
            return null;
        } while (!JKEditingPolicy.isValid((jKDrawingContext = this.owner.getDisplayPolicy().existingCellDrawingContext(point.y, point.x)).getEditingPolicy()));
        return point;
    }

    public void moveForward(Point point) {
        point.translate(1, 0);
    }

    public void moveBack(Point point) {
        point.translate(-1, 0);
    }

    public boolean atEndOfSlice(Rectangle rectangle, Point point) {
        return this.atEndOfSlice(point);
    }

    public boolean atEndOfSlice(Point point) {
        return point.x >= this.adapter.getLastColumnNumber(point.y);
    }

    public boolean atBeginningOfSlice(Rectangle rectangle, Point point) {
        return this.atBeginningOfSlice(point);
    }

    public boolean atBeginningOfSlice(Point point) {
        return point.x <= this.adapter.getFirstColumnNumber(point.y);
    }

    public boolean atEndOfTable(Rectangle rectangle, Point point) {
        return this.atEndOfTable(point);
    }

    public boolean atEndOfTable(Point point) {
        return point.x == this.adapter.getLastColumnNumber(point.y) && point.y == this.adapter.getLastRowNumber();
    }

    public boolean atBeginningOfTable(Rectangle rectangle, Point point) {
        return this.atBeginningOfTable(point);
    }

    public boolean atBeginningOfTable(Point point) {
        return point.x == this.adapter.getFirstColumnNumber(point.y) && point.y == this.adapter.getFirstRowNumber();
    }

    public Point getNextWrappedCell(Rectangle rectangle, Point point) {
        return this.getNextWrappedCell(point);
    }

    public Point getNextWrappedCell(Point point) {
        return point;
    }

    public Point getPreviousWrappedCell(Rectangle rectangle, Point point) {
        return this.getPreviousWrappedCell(point);
    }

    public Point getPreviousWrappedCell(Point point) {
        return point;
    }
}

