/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.tool;

import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.list.JKEvent;
import com.objectshare.grid.list.JKMouseEvent;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKTableTool;
import java.awt.Event;
import java.awt.Point;

public class JKCellEditTool
extends JKTableTool {
    public JKTableTool subAction;
    public boolean preserveSelection = false;

    public JKCellEditTool() {
    }

    public JKCellEditTool(JKTableTool jKTableTool) {
        this.subAction = jKTableTool;
    }

    public JKCellEditTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
        this.subAction = null;
    }

    public JKCellEditTool(JKTableList jKTableList, JKTableListAdapter jKTableListAdapter, JKTableTool jKTableTool) {
        this.owner = jKTableList;
        this.adapter = jKTableListAdapter;
        this.subAction = jKTableTool;
    }

    public void setOwner(JKTableList jKTableList) {
        super.setOwner(jKTableList);
        if (this.subAction != null) {
            this.subAction.setOwner(jKTableList);
        }
    }

    public void setAdapter(JKTableListAdapter jKTableListAdapter) {
        super.setAdapter(jKTableListAdapter);
        if (this.subAction != null) {
            this.subAction.setAdapter(jKTableListAdapter);
        }
    }

    public JKEditingPolicy getEditingPolicy() {
        JKEditEvent jKEditEvent = this.getEditEvent();
        if (jKEditEvent == null) {
            return null;
        }
        return jKEditEvent.getEditAction().editPolicy;
    }

    public JKEditEvent getEditEvent() {
        return ((JKTableEdit)this.owner).getEditEvent();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        JKDrawingContext jKDrawingContext = this.owner.getDisplayPolicy().existingCellDrawingContext(n2, n);
        if (!JKEditingPolicy.isValid(jKDrawingContext.getEditingPolicy())) {
            if (this.subAction != null) {
                return this.subAction.mouseDown(event, n, n2);
            }
            return false;
        }
        JKEditingPolicy jKEditingPolicy = (JKEditingPolicy)jKDrawingContext.getEditingPolicy();
        JKTableEdit jKTableEdit = (JKTableEdit)this.owner;
        if (this.owner.closeEditor()) {
            if (jKEditingPolicy.showEditorOnMouseDown) {
                if (this.showEditor(n, n2)) {
                    jKEditingPolicy.mousePressed(jKTableEdit.getEditEvent(), (JKMouseEvent)((JKEvent)event).getAWTEvent());
                }
            } else {
                this.owner.mouseDragAction = this;
                this.owner.mouseUpAction = this;
            }
            return true;
        }
        return false;
    }

    public void mouseDrag(Event event) {
        Point point = this.adapter.getCellOrNull(event.x, event.y);
        if (point != null) {
            this.owner.keepCellVisible(point.y, point.x);
        }
    }

    public void mouseUp(Event event) {
        Point point = this.owner.getCell(event.x, event.y);
        if (point != null) {
            this.showEditor(point.x, point.y);
        }
        super.mouseUp(event);
    }

    public boolean keyboardEvent(Event event, JKTableArea jKTableArea) {
        if (event.id == 403) {
            JKTableEdit jKTableEdit = (JKTableEdit)this.owner;
            if (jKTableEdit.editAction != null) {
                Point point = this.nextCellByKey(jKTableEdit.editAction.dataX, jKTableEdit.editAction.dataY, event);
                if (point.x == jKTableEdit.editAction.dataX && point.y == jKTableEdit.editAction.dataY) {
                    return false;
                }
                JKDrawingContext jKDrawingContext = this.owner.getDisplayPolicy().existingCellDrawingContext(point.y, point.x);
                if (JKEditingPolicy.isValid(jKDrawingContext.getEditingPolicy())) {
                    this.showEditor(point.x, point.y);
                    return true;
                }
                if (this.subAction != null) {
                    JKTableArea jKTableArea2 = JKTableArea.newForCell(jKTableEdit.editAction.dataX, jKTableEdit.editAction.dataY);
                    this.owner.closeEditor();
                    return this.subAction.keyboardEvent(event, jKTableArea2);
                }
            }
        }
        return false;
    }

    protected boolean showEditor(int n, int n2) {
        JKTableArea jKTableArea;
        JKTableArea jKTableArea2;
        JKTableEdit cfr_ignored_0 = (JKTableEdit)this.owner;
        if (!this.preserveSelection && (jKTableArea2 = this.owner.getSelection()) != (jKTableArea = JKTableArea.empty)) {
            this.owner.setSelection(jKTableArea);
            this.owner.triggerSelected(jKTableArea2, jKTableArea);
        }
        this.owner.keepCellVisible(n2, n);
        if (!this.owner.openEditor(n, n2)) {
            return false;
        }
        this.owner.requestEditorFocus();
        return true;
    }

    public void mouseClicked(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseClicked(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseClicked(jKMouseEvent);
    }

    public void mousePressed(JKMouseEvent jKMouseEvent) {
        super.mousePressed(jKMouseEvent);
    }

    public void mouseReleased(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseReleased(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseReleased(jKMouseEvent);
    }

    public void mouseEntered(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseEntered(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseEntered(jKMouseEvent);
    }

    public void mouseExited(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseExited(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseExited(jKMouseEvent);
    }

    public void mouseDragged(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseDragged(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseDragged(jKMouseEvent);
    }

    public void mouseMoved(JKMouseEvent jKMouseEvent) {
        JKEditingPolicy jKEditingPolicy = this.getEditingPolicy();
        if (jKEditingPolicy != null) {
            jKEditingPolicy.mouseMoved(this.getEditEvent(), jKMouseEvent);
        }
        super.mouseMoved(jKMouseEvent);
    }
}

