/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.list;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntVector;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.list.JKKeyEvent;
import com.objectshare.grid.list.JKMouseEvent;
import com.objectshare.grid.list.JKNoSelectionException;
import com.objectshare.grid.list.JKSelectionEvent;
import com.objectshare.grid.list.JKSelectionListener;
import com.objectshare.grid.list.JKSelectionMulticaster;
import com.objectshare.grid.list.JKTableListAdapter;
import com.objectshare.grid.tool.JKTableTool;
import com.objectshare.grid.view.JKTableView;
import com.objectshare.grid.view.JKTableViewAdapter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JKTableList
extends JKTableView {
    static final long serialVersionUID = -111734923869801499L;
    public JKTableListAdapter rowAdapter;
    public JKTableListAdapter columnAdapter;
    public JKTableListAdapter cellAdapter;
    public JKTableArea selection = JKTableArea.empty;
    protected transient JKTableArea dragArea;
    protected transient Image[] dragImages;
    protected transient Rectangle[] dragRects;
    protected transient Rectangle dragClip;
    public transient JKTableTool mouseDragAction;
    public transient JKTableTool mouseUpAction;
    public JKTableTool keyboardAction;
    protected transient JKTableTool activeTool;
    private transient boolean extraneousMouseRelease = false;
    protected static final String selectionListenerK = "selectionL";
    protected JKSelectionListener selectionListener;

    public JKTableList() {
        this(new JKTableModel());
    }

    public JKTableList(int n, int n2) {
        this(new JKTableModel(n2, n));
    }

    public JKTableList(JKModel jKModel) {
        super(jKModel);
    }

    protected void initHelpers() {
        super.initHelpers();
        this.rowAdapter = (JKTableListAdapter)this.getRowHeaderAdapter();
        this.columnAdapter = (JKTableListAdapter)this.getColumnHeaderAdapter();
        this.cellAdapter = (JKTableListAdapter)this.getCellAdapter();
    }

    public void setModel(JKModel jKModel) {
        this.selection = JKTableArea.empty;
        super.setModel(jKModel);
    }

    public synchronized boolean startDrag(JKTableListAdapter jKTableListAdapter, JKTableArea jKTableArea, Rectangle rectangle) {
        Rectangle[] rectangleArray = jKTableArea.asVirtualBoundsArray(this.dimensions, jKTableListAdapter.getVirtualBounds());
        if (rectangleArray == null) {
            return false;
        }
        this.dragImages = jKTableListAdapter.imagesFor(rectangleArray);
        if (this.dragImages == null) {
            return false;
        }
        this.dragRects = new Rectangle[rectangleArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            this.dragRects[n] = jKTableListAdapter.getScreenRect(rectangleArray[n]);
            ++n;
        }
        this.dragArea = jKTableArea;
        this.dragClip = rectangle;
        return true;
    }

    public synchronized void drag(int n, int n2) {
        if (this.dragImages == null || n == 0 && n2 == 0) {
            return;
        }
        int n3 = this.dragRects.length;
        Rectangle rectangle = this.dragRects[n3 - 1];
        while (--n3 >= 0) {
            Rectangle rectangle2 = this.dragRects[n3];
            rectangle = rectangle.union(rectangle2);
            rectangle2 = new Rectangle(rectangle2.x + n, rectangle2.y + n2, rectangle2.width, rectangle2.height);
            rectangle = rectangle.union(rectangle2);
            this.dragRects[n3] = rectangle2;
        }
        if (this.dragClip != null) {
            rectangle = rectangle.intersection(this.dragClip);
        }
        this.damageScreenRegion(rectangle);
    }

    public synchronized void endDrag() {
        if (this.dragImages == null) {
            return;
        }
        int n = this.dragRects.length;
        Rectangle rectangle = this.dragRects[--n];
        this.dragImages[n].flush();
        while (--n >= 0) {
            rectangle = rectangle.union(this.dragRects[n]);
            this.dragImages[n].flush();
        }
        if (this.dragClip != null) {
            rectangle = rectangle.intersection(this.dragClip);
        }
        this.damageArea(this.dragArea);
        this.damageScreenRegion(rectangle);
        this.dragImages = null;
        this.dragRects = null;
        this.dragArea = null;
        this.dragClip = null;
    }

    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.dragImages != null) {
            if (this.dragClip != null) {
                graphics.clipRect(this.dragClip.x, this.dragClip.y, this.dragClip.width, this.dragClip.height);
            }
            int n = this.dragRects.length;
            while (--n >= 0) {
                Rectangle rectangle = this.dragRects[n];
                graphics.drawImage(this.dragImages[n], rectangle.x, rectangle.y, (ImageObserver)((Object)this));
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        JKKeyEvent jKKeyEvent = new JKKeyEvent(keyEvent);
        this.processJKKeyEvent(jKKeyEvent);
        super.processKeyEvent(keyEvent);
    }

    public void processJKKeyEvent(JKKeyEvent jKKeyEvent) {
        this.processKeyEvent(jKKeyEvent, this.keyboardAction);
        this.processKeyEvent(jKKeyEvent, this.getCellAreaTool());
        this.processKeyEvent(jKKeyEvent, this.getRowHeaderTool());
        this.processKeyEvent(jKKeyEvent, this.getColumnHeaderTool());
    }

    protected void processKeyEvent(JKKeyEvent jKKeyEvent, JKTableTool jKTableTool) {
        if (jKTableTool != null && !jKKeyEvent.isConsumed()) {
            switch (jKKeyEvent.getID()) {
                case 400: {
                    jKTableTool.keyTyped(jKKeyEvent);
                    return;
                }
                case 401: {
                    jKTableTool.keyPressed(jKKeyEvent);
                    return;
                }
                case 402: {
                    jKTableTool.keyReleased(jKKeyEvent);
                    return;
                }
            }
        }
    }

    public JKTableTool getActiveTool() {
        return this.activeTool;
    }

    public void setActiveTool(JKTableTool jKTableTool) {
        this.activeTool = jKTableTool;
        this.mouseDragAction = jKTableTool;
        this.mouseUpAction = jKTableTool;
    }

    public JKTableTool getToolAt(int n, int n2) {
        Point point = this.getCell(n, n2);
        JKDrawingContext jKDrawingContext = point != null ? this.displayPolicy.existingCellDrawingContext(point.y, point.x) : (n < this.coordinator.getScreenX() + this.coordinator.getScreenWidth(0) ? (n2 < this.coordinator.getScreenY() + this.coordinator.getScreenHeight(0) ? this.displayPolicy.topLeftHdrDC : this.displayPolicy.rowHdrDC) : (n2 < this.coordinator.getScreenY() + this.coordinator.getScreenHeight(0) ? this.displayPolicy.columnHdrDC : this.displayPolicy.cellAreaDC));
        Object object = jKDrawingContext.getTool();
        if (object instanceof JKTableTool) {
            return (JKTableTool)object;
        }
        return null;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        JKMouseEvent jKMouseEvent = new JKMouseEvent(mouseEvent);
        JKTableTool jKTableTool = this.getActiveTool();
        if (jKTableTool == null && jKMouseEvent.getID() == 501) {
            jKTableTool = this.getToolAt(jKMouseEvent.getX(), jKMouseEvent.getY());
        }
        if (jKTableTool != null) {
            switch (jKMouseEvent.getID()) {
                case 500: {
                    jKTableTool.mouseClicked(jKMouseEvent);
                    break;
                }
                case 501: {
                    if (this.extraneousMouseRelease) {
                        this.extraneousMouseRelease = false;
                        return;
                    }
                    jKTableTool.mousePressed(jKMouseEvent);
                    if (this.mouseUpAction == this.getActiveTool()) break;
                    this.setActiveTool(this.mouseUpAction);
                    break;
                }
                case 502: {
                    if (jKMouseEvent.getX() == -1 && jKMouseEvent.getY() == -1) {
                        this.extraneousMouseRelease = true;
                        return;
                    }
                    jKTableTool.mouseReleased(jKMouseEvent);
                    if (this.mouseUpAction == this.getActiveTool()) break;
                    this.setActiveTool(this.mouseUpAction);
                    break;
                }
                case 504: {
                    jKTableTool.mouseEntered(jKMouseEvent);
                    break;
                }
                case 505: {
                    jKTableTool.mouseExited(jKMouseEvent);
                    break;
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        JKMouseEvent jKMouseEvent = new JKMouseEvent(mouseEvent);
        JKTableTool jKTableTool = this.getActiveTool();
        if (jKTableTool == null && jKMouseEvent.getID() == 503) {
            jKTableTool = this.getToolAt(jKMouseEvent.getX(), jKMouseEvent.getY());
        }
        if (jKTableTool != null) {
            switch (jKMouseEvent.getID()) {
                case 506: {
                    if (jKMouseEvent.getX() == -1 && jKMouseEvent.getY() == -1) {
                        return;
                    }
                    jKTableTool.mouseDragged(jKMouseEvent);
                    break;
                }
                case 503: {
                    jKTableTool.mouseMoved(jKMouseEvent);
                    break;
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public synchronized void resizeCell(int n, int n2, int n3, int n4) {
        this.setColumnWidth(n2, n, n3);
        this.setRowHeight(n2, n4);
    }

    public JKTableViewAdapter newAdapter(int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        return new JKTableListAdapter(this, n, n2, rectangle, rectangle2);
    }

    public JKTableTool getCellAreaTool() {
        return (JKTableTool)this.displayPolicy.cellAreaDC.getTool();
    }

    public void setCellAreaTool(JKTableTool jKTableTool) {
        if (jKTableTool != null) {
            jKTableTool.setOwner(this);
            jKTableTool.setAdapter(this.cellAdapter);
        }
        this.displayPolicy.cellAreaDC.setTool(jKTableTool);
    }

    public JKTableTool getRowHeaderTool() {
        return (JKTableTool)this.displayPolicy.rowHdrDC.getTool();
    }

    public void setRowHeaderTool(JKTableTool jKTableTool) {
        if (jKTableTool != null) {
            jKTableTool.setOwner(this);
            jKTableTool.setAdapter(this.rowAdapter);
        }
        this.displayPolicy.rowHdrDC.setTool(jKTableTool);
    }

    public JKTableTool getColumnHeaderTool() {
        return (JKTableTool)this.displayPolicy.columnHdrDC.getTool();
    }

    public void setColumnHeaderTool(JKTableTool jKTableTool) {
        if (jKTableTool != null) {
            jKTableTool.setOwner(this);
            jKTableTool.setAdapter(this.columnAdapter);
        }
        this.displayPolicy.columnHdrDC.setTool(jKTableTool);
    }

    public JKTableTool getTopLeftHeaderTool() {
        return (JKTableTool)this.displayPolicy.topLeftHdrDC.getTool();
    }

    public void setTopLeftHeaderTool(JKTableTool jKTableTool) {
        if (jKTableTool != null) {
            jKTableTool.setOwner(this);
            jKTableTool.setAdapter((JKTableListAdapter)this.getTopLeftHeaderAdapter());
        }
        this.displayPolicy.topLeftHdrDC.setTool(jKTableTool);
    }

    public JKTableTool getKeyboardTool() {
        return this.keyboardAction;
    }

    public void setKeyboardTool(JKTableTool jKTableTool) {
        if (jKTableTool != null) {
            jKTableTool.setOwner(this);
            jKTableTool.setAdapter(this.cellAdapter);
        }
        this.keyboardAction = jKTableTool;
    }

    public JKTableArea getSelection() {
        return this.selection;
    }

    public void setSelection(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.getSelection();
        this.basicSetSelection(jKTableArea);
        JKTableArea jKTableArea3 = this.getSelection();
        if (!jKTableArea2.equals(jKTableArea3)) {
            this.triggerSelected(jKTableArea2, jKTableArea3);
        }
    }

    public void basicSetSelection(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.selection;
        JKTableArea jKTableArea3 = this.selection = jKTableArea != null ? jKTableArea : JKTableArea.empty;
        if (!jKTableArea2.equals(this.selection)) {
            this.damageArea(this.selection.xor(jKTableArea2));
        }
    }

    public JKTableArea selection(JKTableArea jKTableArea) {
        JKTableArea jKTableArea2 = this.getSelection();
        this.basicSetSelection(jKTableArea);
        return jKTableArea2;
    }

    public void clearSelection() {
        this.setSelection(JKTableArea.empty);
    }

    public Point selectedCellIndex() throws JKNoSelectionException {
        Point[] pointArray = this.selectedCellIndices();
        if (pointArray.length > 0) {
            return pointArray[0];
        }
        throw new JKNoSelectionException();
    }

    public Point getSelectedCellIndex() throws JKNoSelectionException {
        OSIEnumeration oSIEnumeration = this.getSelectedCellIndices();
        if (oSIEnumeration.hasMoreElements()) {
            return (Point)oSIEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public void setSelectedCellIndex(Point point) {
        this.setSelection(point != null ? JKTableArea.newForCell(point.x, point.y) : JKTableArea.empty);
    }

    public Object selectedCellObject() throws JKNoSelectionException {
        Point point = this.selectedCellIndex();
        return this.data.get(point.y, point.x);
    }

    public Object getSelectedCellObject() throws JKNoSelectionException {
        Point point = this.getSelectedCellIndex();
        return this.data.get(point.y, point.x);
    }

    public Object getSelectedCellObjectOrNull() {
        try {
            return this.getSelectedCellObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public Point[] selectedCellIndices() {
        return this.selection.cellsIn(1, 1, this.data.getNumberOfColumns(), this.data.getNumberOfRows());
    }

    public OSIEnumeration getSelectedCellIndices() {
        return this.selection.cells(1, 1, this.data.getNumberOfRows(), this.data.getNumberOfColumns());
    }

    public Point[] getSelectedCellIndexArray() {
        return this.getSelectedCellIndices().toPointArray();
    }

    public Vector getSelectedCellIndexVector() {
        return this.getSelectedCellIndices().toVector();
    }

    public void setSelectedCellIndices(OSIEnumeration oSIEnumeration) {
        this.setSelectedCellIndices(oSIEnumeration.toPointArray());
    }

    public void setSelectedCellIndices(Point[] pointArray) {
        this.setSelection(JKTableArea.newForCells(pointArray));
    }

    public void setSelectedCellIndices(Vector vector) {
        this.setSelectedCellIndices(OSIEnumeration.newFor((Object)vector));
    }

    public void setSelectedCellIndices(int n, int n2, int n3, int n4) {
        this.setSelection(JKTableArea.newForCells(n2, n, n4, n3));
    }

    public Object[] selectedCellObjects() {
        Point[] pointArray = this.selectedCellIndices();
        int n = pointArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            Point point = pointArray[n];
            objectArray[n] = this.data.get(point.y, point.x);
        }
        return objectArray;
    }

    public OSIEnumeration getSelectedCellObjects() {
        return OSIEnumeration.newFor((Object[])this.getSelectedCellObjectArray());
    }

    public Object[] getSelectedCellObjectArray() {
        Point[] pointArray = this.getSelectedCellIndexArray();
        int n = pointArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            Point point = pointArray[n];
            objectArray[n] = this.data.get(point.y, point.x);
        }
        return objectArray;
    }

    public Vector getSelectedCellObjectVector() {
        return this.getSelectedCellObjects().toVector();
    }

    public int selectedColumnIndex() throws JKNoSelectionException {
        int[] nArray = this.selectedColumnIndices();
        if (nArray.length > 0) {
            return nArray[0];
        }
        throw new JKNoSelectionException();
    }

    public int getSelectedColumnIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getSelectedColumnIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public void setSelectedColumnIndex(int n) {
        this.setSelection(JKTableArea.newForColumn(n));
    }

    public Object selectedColumnObject() throws JKNoSelectionException {
        return this.data.getColumn(this.selectedColumnIndex());
    }

    public Object getSelectedColumnObject() throws JKNoSelectionException {
        return this.data.getColumn(this.getSelectedColumnIndex());
    }

    public Object getSelectedColumnObjectOrNull() {
        try {
            return this.getSelectedColumnObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public void setSelectedColumnObject(Object object) throws NoSuchElementException {
        this.setSelectedColumnIndex(this.data.getColumnNumber(object));
    }

    public int[] selectedColumnIndices() {
        return this.selection.columnsIn(1, this.data.getNumberOfColumns());
    }

    public OSIIntEnumeration getSelectedColumnIndices() {
        return this.selection.columns(1, this.data.getNumberOfColumns());
    }

    public int[] getSelectedColumnIndexArray() {
        return this.getSelectedColumnIndices().toArray();
    }

    public OSIIntVector getSelectedColumnIndexVector() {
        return this.getSelectedColumnIndices().toVector();
    }

    public void setSelectedColumnIndices(OSIIntEnumeration oSIIntEnumeration) {
        this.setSelectedColumnIndices(oSIIntEnumeration.toArray());
    }

    public void setSelectedColumnIndices(int[] nArray) {
        this.setSelection(JKTableArea.newForColumns(nArray));
    }

    public void setSelectedColumnIndices(OSIIntVector oSIIntVector) {
        this.setSelectedColumnIndices(oSIIntVector.toArray());
    }

    public void setSelectedColumnIndices(int n, int n2) {
        this.setSelection(JKTableArea.newForColumns(n, n2));
    }

    public Object[] selectedColumnObjects() {
        int[] nArray = this.selectedColumnIndices();
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = this.data.getColumn(nArray[n]);
        }
        return objectArray;
    }

    public OSIEnumeration getSelectedColumnObjects() {
        return OSIEnumeration.newFor((Object[])this.getSelectedColumnObjectArray());
    }

    public Object[] getSelectedColumnObjectArray() {
        int[] nArray = this.getSelectedColumnIndexArray();
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = this.data.getColumn(nArray[n]);
        }
        return objectArray;
    }

    public Vector getSelectedColumnObjectVector() {
        return this.getSelectedColumnObjects().toVector();
    }

    public void setSelectedColumnObjects(OSIEnumeration oSIEnumeration) throws NoSuchElementException {
        this.setSelectedColumnObjects(oSIEnumeration.toArray());
    }

    public void setSelectedColumnObjects(Object[] objectArray) throws NoSuchElementException {
        this.setSelectedColumnIndices(this.data.getColumnNumbers(objectArray));
    }

    public void setSelectedColumnObjects(Vector vector) throws NoSuchElementException {
        this.setSelectedColumnObjects(OSIEnumeration.newFor((Object)vector));
    }

    public int selectedRowIndex() throws JKNoSelectionException {
        int[] nArray = this.selectedRowIndices();
        if (nArray.length > 0) {
            return nArray[0];
        }
        throw new JKNoSelectionException();
    }

    public int getSelectedRowIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getSelectedRowIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public void setSelectedRowIndex(int n) {
        this.setSelection(JKTableArea.newForRow(n));
    }

    public Object selectedRowObject() throws JKNoSelectionException {
        return this.data.getRow(this.selectedRowIndex());
    }

    public Object getSelectedRowObject() throws JKNoSelectionException {
        return this.data.getRow(this.getSelectedRowIndex());
    }

    public Object getSelectedRowObjectOrNull() {
        try {
            return this.getSelectedRowObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public void setSelectedRowObject(Object object) throws NoSuchElementException {
        this.setSelectedRowIndex(this.data.getRowNumber(object));
    }

    public int[] selectedRowIndices() {
        return this.selection.rowsIn(1, this.data.getNumberOfRows());
    }

    public OSIIntEnumeration getSelectedRowIndices() {
        return this.selection.rows(1, this.data.getNumberOfRows());
    }

    public int[] getSelectedRowIndexArray() {
        return this.getSelectedRowIndices().toArray();
    }

    public OSIIntVector getSelectedRowIndexVector() {
        return this.getSelectedRowIndices().toVector();
    }

    public void setSelectedRowIndices(OSIIntEnumeration oSIIntEnumeration) {
        this.setSelectedRowIndices(oSIIntEnumeration.toArray());
    }

    public void setSelectedRowIndices(int[] nArray) {
        this.setSelection(JKTableArea.newForRows(nArray));
    }

    public void setSelectedRowIndices(OSIIntVector oSIIntVector) {
        this.setSelectedRowIndices(oSIIntVector.toArray());
    }

    public Object[] selectedRowObjects() {
        int[] nArray = this.selectedRowIndices();
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = this.data.getRow(nArray[n]);
        }
        return objectArray;
    }

    public OSIEnumeration getSelectedRowObjects() {
        return OSIEnumeration.newFor((Object[])this.getSelectedRowObjectArray());
    }

    public Object[] getSelectedRowObjectArray() {
        int[] nArray = this.getSelectedRowIndexArray();
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        while (--n >= 0) {
            objectArray[n] = this.data.getRow(nArray[n]);
        }
        return objectArray;
    }

    public Vector getSelectedRowObjectVector() {
        return this.getSelectedRowObjects().toVector();
    }

    public void setSelectedRowObjects(OSIEnumeration oSIEnumeration) throws NoSuchElementException {
        this.setSelectedRowObjects(oSIEnumeration.toArray());
    }

    public void setSelectedRowObjects(Object[] objectArray) throws NoSuchElementException {
        this.setSelectedRowIndices(this.data.getRowNumbers(objectArray));
    }

    public void setSelectedRowObjects(Vector vector) throws NoSuchElementException {
        this.setSelectedRowObjects(OSIEnumeration.newFor((Object)vector));
    }

    public void addSelectionListener(JKSelectionListener jKSelectionListener) {
        this.selectionListener = JKSelectionMulticaster.add(this.selectionListener, jKSelectionListener);
    }

    public void removeSelectionListener(JKSelectionListener jKSelectionListener) {
        this.selectionListener = JKSelectionMulticaster.remove(this.selectionListener, jKSelectionListener);
    }

    public void addJKSelectionListener(JKSelectionListener jKSelectionListener) {
        this.selectionListener = JKSelectionMulticaster.add(this.selectionListener, jKSelectionListener);
    }

    public void removeJKSelectionListener(JKSelectionListener jKSelectionListener) {
        this.selectionListener = JKSelectionMulticaster.remove(this.selectionListener, jKSelectionListener);
    }

    public JKTableArea triggerSelecting(JKTableArea jKTableArea, JKTableArea jKTableArea2) {
        JKTableArea jKTableArea3 = jKTableArea2;
        if (this.selectionListener != null) {
            JKSelectionEvent jKSelectionEvent = new JKSelectionEvent(this, jKTableArea, jKTableArea2);
            this.selectionListener.jkSelecting(jKSelectionEvent);
            jKTableArea3 = jKSelectionEvent.getNewSelection();
        }
        return jKTableArea3;
    }

    public void triggerSelected(JKTableArea jKTableArea, JKTableArea jKTableArea2) {
        if (this.selectionListener != null) {
            this.selectionListener.jkSelected(new JKSelectionEvent(this, jKTableArea, jKTableArea2));
        }
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        super.modelRowsAdded(jKModelRowsAddedEvent);
        this.selection = this.selection.insertRows(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize());
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        super.modelRowsRemoved(jKModelRowsRemovedEvent);
        this.selection = this.selection.removeRows(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize());
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
        super.modelRowsReordered(jKModelRowsReorderEvent);
        this.selection = this.selection.reorderRows(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getReorderMap());
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        super.modelColumnsAdded(jKModelColsAddedEvent);
        this.selection = this.selection.insertColumns(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        super.modelColumnsRemoved(jKModelColsRemovedEvent);
        this.selection = this.selection.removeColumns(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
        super.modelColumnsReordered(jKModelColsReorderEvent);
        this.selection = this.selection.reorderColumns(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap());
    }

    public boolean openEditor(int n, int n2) {
        return false;
    }

    public synchronized void showEditor() {
    }

    public void requestEditorFocus() {
    }

    public void hideEditor() {
    }

    public void hideEditor(long l) {
    }

    public boolean closeEditor() {
        return true;
    }
}

