/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.list;

import com.objectshare.base.util.OSIArray;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.list.JKNoSelectionException;
import com.objectshare.grid.list.JKTableList;
import java.awt.Point;
import java.util.EventObject;

public class JKSelectionEvent
extends EventObject {
    JKTableArea oldSelection;
    JKTableArea newSelection;
    JKTableList table;
    JKModel model;
    int numRows;
    int numColumns;

    public JKSelectionEvent(JKTableList jKTableList, JKTableArea jKTableArea, JKTableArea jKTableArea2) {
        super(jKTableList);
        if (jKTableArea == null || jKTableArea2 == null) {
            throw new IllegalArgumentException("null selection");
        }
        this.oldSelection = jKTableArea;
        this.newSelection = jKTableArea2;
        this.table = jKTableList;
        this.model = jKTableList.data;
        this.numRows = this.model.getNumberOfRows();
        this.numColumns = this.model.getNumberOfColumns();
    }

    public JKTableList getTable() {
        return (JKTableList)this.getSource();
    }

    public JKTableArea getOldSelection() {
        return this.oldSelection;
    }

    public JKTableArea getNewSelection() {
        return this.newSelection;
    }

    public void setNewSelection(JKTableArea jKTableArea) {
        if (jKTableArea == null) {
            throw new Error("null selection");
        }
        this.newSelection = jKTableArea;
    }

    public boolean hasChanged() {
        return !this.getNewSelection().equals(this.getOldSelection());
    }

    public Point getOldSelectedCellIndex() throws JKNoSelectionException {
        OSIEnumeration oSIEnumeration = this.getOldSelectedCellIndices();
        if (oSIEnumeration.hasMoreElements()) {
            return (Point)oSIEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public Point getNewSelectedCellIndex() throws JKNoSelectionException {
        OSIEnumeration oSIEnumeration = this.getNewSelectedCellIndices();
        if (oSIEnumeration.hasMoreElements()) {
            return (Point)oSIEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public Object getOldSelectedCellObject() throws JKNoSelectionException {
        Point point = this.getOldSelectedCellIndex();
        return this.model.get(point.y, point.x);
    }

    public Object getOldSelectedCellObjectOrNull() {
        try {
            return this.getOldSelectedCellObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public Object getNewSelectedCellObject() throws JKNoSelectionException {
        Point point = this.getNewSelectedCellIndex();
        return this.model.get(point.y, point.x);
    }

    public Object getNewSelectedCellObjectOrNull() {
        try {
            return this.getNewSelectedCellObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public OSIEnumeration getOldSelectedCellIndices() {
        return this.oldSelection.cells(1, 1, this.numRows, this.numColumns);
    }

    public OSIEnumeration getNewSelectedCellIndices() {
        return this.newSelection.cells(1, 1, this.numRows, this.numColumns);
    }

    public OSIEnumeration getOldSelectedCellObjects() {
        return this.getCellObjects(this.getOldSelectedCellIndices());
    }

    public OSIEnumeration getNewSelectedCellObjects() {
        return this.getCellObjects(this.getNewSelectedCellIndices());
    }

    OSIEnumeration getCellObjects(OSIEnumeration oSIEnumeration) {
        OSIArray oSIArray = new OSIArray();
        while (oSIEnumeration.hasMoreElements()) {
            Point point = (Point)oSIEnumeration.nextElement();
            oSIArray.add(this.model.get(point.y, point.x));
        }
        return oSIArray.elements();
    }

    public int getOldSelectedColumnIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getOldSelectedColumnIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public int getNewSelectedColumnIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getNewSelectedColumnIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public Object getOldSelectedColumnObject() throws JKNoSelectionException {
        return this.model.getColumn(this.getOldSelectedColumnIndex());
    }

    public Object getOldSelectedColumnObjectOrNull() {
        try {
            return this.getOldSelectedColumnObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public Object getNewSelectedColumnObject() throws JKNoSelectionException {
        return this.model.getColumn(this.getNewSelectedColumnIndex());
    }

    public Object getNewSelectedColumnObjectOrNull() {
        try {
            return this.getNewSelectedColumnObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public OSIIntEnumeration getOldSelectedColumnIndices() {
        return this.oldSelection.columns(1, this.numColumns);
    }

    public OSIIntEnumeration getNewSelectedColumnIndices() {
        return this.newSelection.columns(1, this.numColumns);
    }

    public OSIEnumeration getOldSelectedColumnObjects() {
        return this.getColumnObjects(this.getOldSelectedColumnIndices());
    }

    public OSIEnumeration getNewSelectedColumnObjects() {
        return this.getColumnObjects(this.getNewSelectedColumnIndices());
    }

    OSIEnumeration getColumnObjects(OSIIntEnumeration oSIIntEnumeration) {
        OSIArray oSIArray = new OSIArray();
        while (oSIIntEnumeration.hasMoreElements()) {
            oSIArray.add(this.model.getColumn(oSIIntEnumeration.nextElement()));
        }
        return oSIArray.elements();
    }

    public int getOldSelectedRowIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getOldSelectedRowIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public int getNewSelectedRowIndex() throws JKNoSelectionException {
        OSIIntEnumeration oSIIntEnumeration = this.getNewSelectedRowIndices();
        if (oSIIntEnumeration.hasMoreElements()) {
            return oSIIntEnumeration.nextElement();
        }
        throw new JKNoSelectionException();
    }

    public Object getOldSelectedRowObject() throws JKNoSelectionException {
        return this.model.getRow(this.getOldSelectedRowIndex());
    }

    public Object getOldSelectedRowObjectOrNull() {
        try {
            return this.getOldSelectedRowObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public Object getNewSelectedRowObject() throws JKNoSelectionException {
        return this.model.getRow(this.getNewSelectedRowIndex());
    }

    public Object getNewSelectedRowObjectOrNull() {
        try {
            return this.getNewSelectedRowObject();
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            return null;
        }
    }

    public OSIIntEnumeration getOldSelectedRowIndices() {
        return this.oldSelection.rows(1, this.numRows);
    }

    public OSIIntEnumeration getNewSelectedRowIndices() {
        return this.newSelection.rows(1, this.numRows);
    }

    public OSIEnumeration getOldSelectedRowObjects() {
        return this.getRowObjects(this.getOldSelectedRowIndices());
    }

    public OSIEnumeration getNewSelectedRowObjects() {
        return this.getRowObjects(this.getNewSelectedRowIndices());
    }

    OSIEnumeration getRowObjects(OSIIntEnumeration oSIIntEnumeration) {
        OSIArray oSIArray = new OSIArray();
        while (oSIIntEnumeration.hasMoreElements()) {
            oSIArray.add(this.model.getRow(oSIIntEnumeration.nextElement()));
        }
        return oSIArray.elements();
    }
}

