/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.viewing;

import com.objectshare.grid.example.JKExampleApplet;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.view.JKDrawViewEvent;
import com.objectshare.grid.view.JKDrawViewListener;
import com.objectshare.grid.view.JKTableView;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class SimpleTable
extends JKExampleApplet
implements JKDrawViewListener,
ActionListener,
MouseListener {
    public JKTableView table;
    public int row = 1;
    public int column = 1;
    public Color backColor = Color.black;
    public Label rowLabel = new Label("Row:");
    public Label columnLabel = new Label("Column:");
    public Label valueLabel = new Label("Value:");
    public TextField rowField = new TextField(String.valueOf(this.row));
    public TextField columnField = new TextField(String.valueOf(this.column));
    public TextField valueField = new TextField(String.valueOf(this.row) + "," + this.column);
    public Button getButton = new Button("Get");
    public Button setButton = new Button("Set");
    public Button autoSizeButton = new Button("AutoSize");

    public static void main(String[] stringArray) {
        SimpleTable simpleTable = new SimpleTable();
        new JKExampleFrame(simpleTable, "SimpleTableExample", 353, 380);
    }

    public void init() {
        super.init();
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        this.initControls();
        this.initTable();
        this.addListeners();
    }

    public void initSaveControls() {
        Panel panel = new Panel();
        ((Container)((Object)this)).add("South", panel);
        FlowLayout flowLayout = new FlowLayout();
        panel.setLayout(flowLayout);
    }

    public void initTable() {
        this.table = new JKTableView(10, 12);
        ((Container)((Object)this)).add("Center", (Component)((Object)this.table));
        this.initTableData();
    }

    public void changeTable() {
        this.table.setBackColor(new Color(200, 200, 255));
        this.table.setRowHeaders(false);
        this.table.getModel().set(0, 1, "COLUMN 1 HDR");
        this.table.setColumnForeColor(3, Color.red);
        this.table.setRowBackColor(4, Color.yellow);
        this.table.setColumnHeaderBackColor(Color.green);
        this.table.setVerticalScroll(null);
    }

    protected void initTableData() {
        int n = 1;
        while (n <= this.table.data.getNumberOfColumns()) {
            int n2 = 1;
            while (n2 <= this.table.data.getNumberOfRows()) {
                this.table.data.set(n2, n, String.valueOf(n2) + "," + n);
                ++n2;
            }
            ++n;
        }
    }

    public void addListeners() {
        ((Component)((Object)this.table)).addMouseListener(this);
        this.table.addJKDrawViewListener(this);
    }

    public void removeListeners() {
        ((Component)((Object)this.table)).removeMouseListener(this);
        this.table.removeJKDrawViewListener(this);
    }

    public void initControls() {
        Panel panel = new Panel();
        ((Container)((Object)this)).add("North", panel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.09;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 3);
        gridBagLayout.setConstraints(this.rowLabel, gridBagConstraints);
        panel.add(this.rowLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(10, 0, 10, 12);
        gridBagLayout.setConstraints(this.rowField, gridBagConstraints);
        panel.add(this.rowField);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.09;
        gridBagConstraints.insets = new Insets(10, 0, 10, 3);
        gridBagLayout.setConstraints(this.columnLabel, gridBagConstraints);
        panel.add(this.columnLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.insets = new Insets(10, 0, 10, 12);
        gridBagLayout.setConstraints(this.columnField, gridBagConstraints);
        panel.add(this.columnField);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.09;
        gridBagConstraints.insets = new Insets(10, 0, 10, 3);
        gridBagLayout.setConstraints(this.valueLabel, gridBagConstraints);
        panel.add(this.valueLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.insets = new Insets(10, 0, 10, 12);
        gridBagLayout.setConstraints(this.valueField, gridBagConstraints);
        panel.add(this.valueField);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        gridBagLayout.setConstraints(this.getButton, gridBagConstraints);
        panel.add(this.getButton);
        gridBagLayout.setConstraints(this.setButton, gridBagConstraints);
        panel.add(this.setButton);
        gridBagLayout.setConstraints(this.autoSizeButton, gridBagConstraints);
        panel.add(this.autoSizeButton);
    }

    public boolean handleEvent(Event event) {
        if (event.id != 1001) {
            return super.handleEvent(event);
        }
        if (event.target == this.getButton) {
            this.getCellValue();
            return true;
        }
        if (event.target == this.setButton) {
            this.setCellValue();
            return true;
        }
        if (event.target == this.autoSizeButton) {
            this.table.autoSize();
            return true;
        }
        return super.handleEvent(event);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getButton) {
            this.getCellValue();
            return;
        }
        if (actionEvent.getSource() == this.setButton) {
            this.setCellValue();
            return;
        }
        if (actionEvent.getSource() == this.autoSizeButton) {
            this.table.autoSize();
        }
    }

    public void getCellValue() {
        int n = this.row;
        int n2 = this.column;
        try {
            this.row = new Integer(this.rowField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.column = new Integer(this.columnField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        ((TextComponent)this.valueField).setText(this.table.getModel().getString(this.row, this.column));
        this.table.repaintCells(n2, n, 1, 1);
        this.backColor = Color.blue;
        this.table.repaintCells(this.column, this.row, 1, 1);
    }

    public void setCellValue() {
        int n = this.row;
        int n2 = this.column;
        try {
            this.row = new Integer(this.rowField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.column = new Integer(this.columnField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        this.table.repaintCells(n2, n, 1, 1);
        this.backColor = Color.red;
        this.table.getModel().set(this.row, this.column, this.valueField.getText());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent.getSource() == this.table && (point = this.table.cellForPoint(mouseEvent.getX(), mouseEvent.getY())) != null) {
            Point point2 = new Point(this.column, this.row);
            this.column = point.x;
            this.row = point.y;
            ((TextComponent)this.columnField).setText(String.valueOf(this.column));
            ((TextComponent)this.rowField).setText(String.valueOf(this.row));
            ((TextComponent)this.valueField).setText(this.table.getModel().getString(this.row, this.column));
            this.backColor = Color.black;
            this.table.repaintCells(point2.x, point2.y, 1, 1);
            this.table.repaintCells(point.x, point.y, 1, 1);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void jkDrawCell(JKDrawViewEvent jKDrawViewEvent) {
        if (jKDrawViewEvent.getColumn() == this.column && jKDrawViewEvent.getRowNumber() == this.row) {
            jKDrawViewEvent.setBackColor(this.backColor);
            jKDrawViewEvent.setForeColor(Color.white);
        }
    }

    public void jkCellExtent(JKDrawViewEvent jKDrawViewEvent) {
    }
}

