/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.editEvent;

import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.edit.JKChoiceEditingPolicy;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKEditListener;
import com.objectshare.grid.edit.JKVetoEditException;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.howto.JKTableEditHowTo;
import java.awt.Checkbox;
import java.awt.Color;

public class EditEvents
extends JKTableEditHowTo
implements JKEditListener {
    public static String[] choices = new String[]{"Choice 1", "Choice 2", "Choice 3", "Choice 4", "Choice 5", "Choice 6"};
    protected Checkbox vetoAboutToEditCB;
    protected Checkbox vetoValidateEditCB;
    protected Checkbox validateUppercaseCB;

    public static void main(String[] stringArray) {
        EditEvents editEvents = new EditEvents();
        new JKExampleFrame(editEvents, "Edit Events", 560, 350);
    }

    protected void initTable() {
        super.initTable();
        this.initTableData(this.table);
        this.table.setColumnEditingPolicy(3, new JKChoiceEditingPolicy(choices));
        JKModel jKModel = this.table.getModel();
        int n = 1;
        while (n < jKModel.getNumberOfRows()) {
            jKModel.set(n, 3, "Choice 1");
            ++n;
        }
        this.table.setColumnBackColor(3, Color.pink);
        this.table.addJKEditListener(this);
    }

    protected void initControlPanel() {
        this.initEventMonitorControlPanel();
    }

    protected void initControls() {
        this.vetoAboutToEditCB = new Checkbox("Veto AboutToEdit");
        this.controls.add(this.vetoAboutToEditCB);
        this.vetoValidateEditCB = new Checkbox("Veto ValidateEdit");
        this.controls.add(this.vetoValidateEditCB);
        this.validateUppercaseCB = new Checkbox("Convert to Uppercase");
        this.controls.add(this.validateUppercaseCB);
        super.initControls();
    }

    public void jkAboutToEdit(JKEditEvent jKEditEvent) throws JKVetoEditException {
        boolean bl = this.vetoAboutToEditCB.getState();
        this.printEvent("AboutToEdit(" + jKEditEvent.getColumnNumber() + "," + jKEditEvent.getRowNumber() + ")" + (bl ? " <== VETO !" : ""));
        if (bl) {
            throw new JKVetoEditException();
        }
    }

    public void jkEditing(JKEditEvent jKEditEvent) {
        this.printEvent("Editing(" + jKEditEvent.getColumnNumber() + "," + jKEditEvent.getRowNumber() + ")");
    }

    public void jkValidateEdit(JKEditEvent jKEditEvent) throws JKVetoEditException {
        boolean bl = this.vetoValidateEditCB.getState();
        this.printEvent("ValidateEdit(" + jKEditEvent.getColumnNumber() + "," + jKEditEvent.getRowNumber() + ")" + " hasChanged()=" + jKEditEvent.hasChanged() + (bl ? " <== VETO !" : ""));
        if (bl) {
            throw new JKVetoEditException();
        }
        boolean bl2 = this.validateUppercaseCB.getState();
        if (bl2) {
            jKEditEvent.setNewValue(((String)jKEditEvent.getNewValue()).toUpperCase());
        }
    }

    public void jkEdited(JKEditEvent jKEditEvent) {
        this.printEvent("Edited(" + jKEditEvent.getColumnNumber() + "," + jKEditEvent.getRowNumber() + ")");
    }
}

