/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.columnTotal;

import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelListener;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.view.JKDrawViewEvent;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Observable;

public class Totaler
extends Observable
implements JKModelListener,
JKDrawnObject {
    protected JKModel model;
    protected int column;
    protected int total;
    protected String totalString = "0";
    protected boolean changing = false;

    public Totaler(JKModel jKModel, int n) {
        this.model = jKModel;
        this.column = n;
        this.model.addModelListener(this);
    }

    public void changed() {
        if (!this.changing) {
            try {
                this.changing = true;
                this.totalString = null;
                this.setChanged();
                this.notifyObservers();
                return;
            }
            finally {
                Object var2_1 = null;
                this.changing = false;
            }
        }
    }

    public String getTotalString() {
        if (this.totalString == null) {
            this.calculate();
        }
        return this.totalString;
    }

    public void calculate() {
        this.total = 0;
        int n = 1;
        while (n <= this.model.getNumberOfRows()) {
            this.total += this.convert(this.model.get(n, this.column));
            ++n;
        }
        this.totalString = new Integer(this.total).toString();
    }

    public int convert(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            int n = ((Number)object).intValue();
            return n;
        }
        try {
            int n = new Integer(object.toString());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void jkPreDraw(JKDrawViewEvent jKDrawViewEvent) {
        if (jKDrawViewEvent.getHorizontalJustification() == 0) {
            jKDrawViewEvent.setHorizontalJustification(3);
        }
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        jKDrawViewEvent.drawString(this.getTotalString(), rectangle);
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        return jKDrawViewEvent.stringExtent(this.getTotalString());
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
        this.changed();
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
    }
}

