/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.explorer;

import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.draw.JKDrawnString;
import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKEditedObject;
import com.objectshare.grid.list.JKDrawListEvent;
import com.objectshare.grid.view.JKDrawViewEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class ExplorerDrawnFile
implements JKDrawnObject,
JKEditedObject {
    public transient Image image;
    public Object cellValue;
    public JKDrawnObject cellObject;

    public ExplorerDrawnFile(Image image, Object object) {
        this.image = image;
        this.cellValue = object;
        this.cellObject = JKDrawnString.newFor(this.cellValue);
    }

    public void jkPreDraw(JKDrawViewEvent jKDrawViewEvent) {
        this.cellObject.jkPreDraw(jKDrawViewEvent);
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        int n = 0;
        if (this.image != null) {
            n = this.image.getWidth((ImageObserver)((Object)jKDrawViewEvent.owner)) + 4;
            if (jKDrawViewEvent instanceof JKDrawListEvent && ((JKDrawListEvent)jKDrawViewEvent).isSelected()) {
                jKDrawViewEvent.graphics.setColor(Color.black);
                jKDrawViewEvent.graphics.setXORMode(Color.white);
            }
            jKDrawViewEvent.graphics.drawImage(this.image, rectangle.x + 1, rectangle.y + 1, (ImageObserver)((Object)jKDrawViewEvent.owner));
            jKDrawViewEvent.graphics.setPaintMode();
        }
        this.cellObject.jkDraw(jKDrawViewEvent, new Rectangle(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height));
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        int n = 0;
        if (this.image != null) {
            n = this.image.getWidth((ImageObserver)((Object)jKDrawViewEvent.owner)) + 4;
        }
        Dimension dimension = this.cellObject.jkExtent(jKDrawViewEvent);
        return new Dimension(dimension.width + n, dimension.height);
    }

    public Object jkEdit(JKEditAction jKEditAction, Object object) {
        return jKEditAction.jkEdit(this.cellValue.toString());
    }

    public Rectangle jkEditFrame(JKEditAction jKEditAction, Rectangle rectangle) {
        int n = 0;
        if (this.image != null) {
            n = this.image.getWidth((ImageObserver)((Object)jKEditAction.owner)) + jKEditAction.borderInsets().left + jKEditAction.contentInsets().left + 4;
        }
        return new Rectangle(rectangle.x + n, rectangle.y, rectangle.width - n, rectangle.height);
    }
}

