/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.draw;

import com.objectshare.grid.data.JKHierarchicalAdapter;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKEditedObject;
import com.objectshare.grid.view.JKDrawViewEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class JKHierDrawnObject
implements JKDrawnObject,
JKEditedObject,
Serializable {
    protected JKHierarchicalAdapter hAdapter;
    protected int hIndent;
    protected int pIndent;
    protected JKDrawnObject hObject;
    public static int hIndentPerLevel = 15;

    public static JKDrawnObject newFor(Object object, JKDrawnObject jKDrawnObject) {
        if (object instanceof JKHierarchicalAdapter) {
            return new JKHierDrawnObject((JKHierarchicalAdapter)object, jKDrawnObject);
        }
        return jKDrawnObject;
    }

    public JKHierDrawnObject(JKHierarchicalAdapter jKHierarchicalAdapter, JKDrawnObject jKDrawnObject) {
        this.hAdapter = jKHierarchicalAdapter;
        this.hIndent = this.hAdapter.getHierarchicalIndent();
        this.pIndent = this.hIndent * hIndentPerLevel;
        this.hObject = jKDrawnObject;
    }

    public void jkPreDraw(JKDrawViewEvent jKDrawViewEvent) {
        this.hObject.jkPreDraw(jKDrawViewEvent);
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        Insets insets = jKDrawViewEvent.borderInsets();
        Rectangle rectangle2 = this.cellBoxFor(rectangle);
        this.drawHierarchy(jKDrawViewEvent.graphics, rectangle.x, jKDrawViewEvent.cellBox.y + insets.top, rectangle2.x - rectangle.x, jKDrawViewEvent.cellBox.height - insets.top - insets.bottom, jKDrawViewEvent.getBackColor());
        this.hObject.jkDraw(jKDrawViewEvent, rectangle2);
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        Dimension dimension = this.hObject.jkExtent(jKDrawViewEvent);
        return new Dimension(dimension.width + this.pIndent, dimension.height);
    }

    public Object jkEdit(JKEditAction jKEditAction, Object object) {
        if (this.hObject instanceof JKEditedObject) {
            return ((JKEditedObject)((Object)this.hObject)).jkEdit(jKEditAction, object);
        }
        return jKEditAction.jkEdit(object);
    }

    public Rectangle jkEditFrame(JKEditAction jKEditAction, Rectangle rectangle) {
        Rectangle rectangle2 = this.cellBoxFor(rectangle);
        if (this.hObject instanceof JKEditedObject) {
            rectangle2 = ((JKEditedObject)((Object)this.hObject)).jkEditFrame(jKEditAction, rectangle2);
        }
        return rectangle2;
    }

    public final Rectangle cellBoxFor(Rectangle rectangle) {
        return new Rectangle(rectangle.x + this.pIndent, rectangle.y, rectangle.width - this.pIndent, rectangle.height);
    }

    final void drawHierarchy(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (this.hIndent < 1) {
            return;
        }
        int n5 = n + (this.hIndent - 1) * hIndentPerLevel;
        JKHierarchicalAdapter jKHierarchicalAdapter = this.hAdapter.getParentAdapter();
        this.drawHierarchyNode(graphics, jKHierarchicalAdapter, n5, n2, hIndentPerLevel, n4, color);
        while (n5 > n && jKHierarchicalAdapter != null) {
            this.drawHierarchyLine(graphics, jKHierarchicalAdapter, n5 -= hIndentPerLevel, n2, hIndentPerLevel, n4, color);
            jKHierarchicalAdapter = jKHierarchicalAdapter.getParentAdapter();
        }
    }

    final void drawHierarchyNode(Graphics graphics, JKHierarchicalAdapter jKHierarchicalAdapter, int n, int n2, int n3, int n4, Color color) {
        int n5 = n + n3 / 2;
        int n6 = n2 + n4 / 2;
        if (this.hAdapter.isLastChild()) {
            if (jKHierarchicalAdapter != null) {
                JKHierDrawnObject.drawVertLine(graphics, n5, n2, n6 - n2, color);
            }
        } else if (jKHierarchicalAdapter != null) {
            JKHierDrawnObject.drawVertLine(graphics, n5, n2, n4, color);
        } else {
            JKHierDrawnObject.drawVertLine(graphics, n5, n6, n2 + n4 - n6, color);
        }
        JKHierDrawnObject.drawHorzLine(graphics, n5, n6, n + n3 - n5, color);
        if (this.hAdapter.mayHaveChildren()) {
            if (this.hAdapter.isExpanded()) {
                JKHierDrawnObject.drawExpanded(graphics, n5 - 4, n6 - 4, color);
                return;
            }
            JKHierDrawnObject.drawCollapsed(graphics, n5 - 4, n6 - 4, color);
        }
    }

    final void drawHierarchyLine(Graphics graphics, JKHierarchicalAdapter jKHierarchicalAdapter, int n, int n2, int n3, int n4, Color color) {
        if (jKHierarchicalAdapter != null && !jKHierarchicalAdapter.isLastChild()) {
            JKHierDrawnObject.drawVertLine(graphics, n + n3 / 2, n2, n4, color);
        }
    }

    static final void drawCollapsed(Graphics graphics, int n, int n2, Color color) {
        JKHierDrawnObject.drawExpanded(graphics, n, n2, color);
        graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 6);
    }

    static final void drawExpanded(Graphics graphics, int n, int n2, Color color) {
        if (Color.white.equals(color)) {
            graphics.setColor(Color.darkGray);
        } else if (Color.black.equals(color)) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawRect(n, n2, 8, 8);
        graphics.setColor(color);
        graphics.fillRect(n + 1, n2 + 1, 7, 7);
        if (Color.black.equals(color)) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        graphics.drawLine(n + 2, n2 + 4, n + 6, n2 + 4);
    }

    static final void drawHorzLine(Graphics graphics, int n, int n2, int n3, Color color) {
        if (Color.white.equals(color)) {
            graphics.setColor(Color.gray);
        } else if (Color.black.equals(color)) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        int n4 = 0;
        while (n4 < n3) {
            graphics.drawLine(n + n4, n2, n + n4, n2);
            n4 += 2;
        }
    }

    static final void drawVertLine(Graphics graphics, int n, int n2, int n3, Color color) {
        if (Color.white.equals(color)) {
            graphics.setColor(Color.gray);
        } else if (Color.black.equals(color)) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.black);
        }
        int n4 = 0;
        while (n4 < n3) {
            graphics.drawLine(n, n2 + n4, n, n2 + n4);
            n4 += 2;
        }
    }
}

