/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.draw;

import com.objectshare.grid.draw.JKCloneableDrawnValue;
import com.objectshare.grid.draw.JKDrawnImage;
import com.objectshare.grid.draw.JKDrawnNumber;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.draw.JKDrawnValue;
import com.objectshare.grid.view.JKDrawViewEvent;
import com.objectshare.grid.view.JKTableView;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class JKDrawnString
implements JKCloneableDrawnValue,
Cloneable,
Serializable {
    public static final String emptyString = "";
    public static final String undefinedString = "<undefined>";
    public static final JKDrawnString empty = new JKDrawnString("");
    public static JKDrawnObject undefined = empty;
    protected static Hashtable drawnValueClassMap = null;
    public String value;

    public JKDrawnString() {
        this(undefinedString);
    }

    public JKDrawnString(String string) {
        this.value = string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static JKDrawnObject newFor(Object object) {
        return JKDrawnString.newFor(null, object);
    }

    public static JKDrawnObject newFor(JKTableView jKTableView, Object object) {
        Object object2;
        if (object instanceof JKDrawnObject) {
            return (JKDrawnObject)object;
        }
        if (object == null) {
            return undefined;
        }
        Object object3 = object2 = jKTableView != null ? jKTableView.getDrawnValueOrNullFor(object) : JKDrawnString.getDrawnValueOrNullFor(object);
        if (object2 != null) {
            JKDrawnValue jKDrawnValue;
            if (object2 instanceof Class) {
                try {
                    jKDrawnValue = (JKDrawnValue)((Class)object2).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new Error("cannot instantiate drawn value: " + ((Class)object2).getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error("illegal access exception: " + ((Class)object2).getName());
                }
            }
            try {
                jKDrawnValue = (JKDrawnValue)((JKCloneableDrawnValue)object2).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("cannot clone drawn value instance: " + object2.getClass().getName());
            }
            jKDrawnValue.setValue(object);
            return jKDrawnValue;
        }
        if (object instanceof Number) {
            return new JKDrawnNumber((Number)object);
        }
        if (object instanceof Image) {
            return new JKDrawnImage((Image)object);
        }
        if (emptyString.equals(object)) {
            return empty;
        }
        return new JKDrawnString(object.toString());
    }

    public static void addDrawnValueAssociation(Object object, Object object2) {
        if (drawnValueClassMap == null) {
            drawnValueClassMap = new Hashtable();
        }
        JKDrawnString.addDrawnValueAssociation(object, object2, drawnValueClassMap);
    }

    public static void addDrawnValueAssociation(Object object, Object object2, Hashtable hashtable) {
        if (object == null) {
            throw new IllegalArgumentException("must specify object class or class name or instance");
        }
        String string = object instanceof String ? (String)object : (object instanceof Class ? ((Class)object).getName() : object.getClass().getName());
        if (!(object2 instanceof String || object2 instanceof Class || object2 instanceof JKCloneableDrawnValue)) {
            throw new IllegalArgumentException("must specify drawn value class or class name or instance of JKCloneableDrawnValue");
        }
        hashtable.put(string, object2);
    }

    public static void removeDrawnValueAssociation(String string) {
        if (drawnValueClassMap != null) {
            drawnValueClassMap.remove(string);
            if (drawnValueClassMap.isEmpty()) {
                drawnValueClassMap = null;
            }
        }
    }

    public static Object getDrawnValueOrNullFor(Object object) {
        return JKDrawnString.getDrawnValueOrNullFor(object, drawnValueClassMap);
    }

    public static Object getDrawnValueOrNullFor(Object object, Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(object.getClass().getName());
        if (v instanceof String) {
            try {
                Class<?> clazz = Class.forName((String)v);
                hashtable.put(object.getClass().getName(), clazz);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("class not found exception: " + v);
            }
        }
        return v;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object.toString();
    }

    public void jkPreDraw(JKDrawViewEvent jKDrawViewEvent) {
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        jKDrawViewEvent.drawString(this.value, rectangle);
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        return jKDrawViewEvent.stringExtent(this.value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + (this.value != null ? this.value : "null") + ")";
    }
}

