/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIIntVector;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelListener;
import com.objectshare.grid.data.JKModelMulticaster;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import java.io.Serializable;

final class JKModelEventManager
implements Serializable {
    JKModel model;
    JKModelListener modelListener;

    JKModelEventManager(JKModel jKModel) {
        this.model = jKModel;
    }

    public synchronized void addModelListener(JKModelListener jKModelListener) {
        this.addJKModelListener(jKModelListener);
    }

    public synchronized void removeModelListener(JKModelListener jKModelListener) {
        this.removeJKModelListener(jKModelListener);
    }

    public synchronized void addJKModelListener(JKModelListener jKModelListener) {
        if (this.model.getAutoConnect() && this.modelListener == null && jKModelListener != null) {
            this.model.connect();
        }
        this.modelListener = JKModelMulticaster.add(this.modelListener, jKModelListener);
    }

    public synchronized void removeJKModelListener(JKModelListener jKModelListener) {
        JKModelListener jKModelListener2 = this.modelListener;
        this.modelListener = JKModelMulticaster.remove(this.modelListener, jKModelListener);
        if (this.model.getAutoConnect() && jKModelListener2 != null && this.modelListener == null) {
            this.model.release();
        }
    }

    synchronized void triggerChanged(JKTableArea jKTableArea) {
        if (this.modelListener != null) {
            this.modelListener.modelChanged(new JKModelChangedEvent(this.model, jKTableArea));
        }
    }

    synchronized void triggerRowsChanged(int n, Object[] objectArray) {
        if (this.modelListener != null) {
            this.modelListener.modelRowsChanged(new JKModelRowsChangedEvent(this.model, n, objectArray));
        }
    }

    synchronized void triggerRowsAdded(int n, int n2) {
        if (this.modelListener != null) {
            this.modelListener.modelRowsAdded(new JKModelRowsAddedEvent(this.model, n, n2));
        }
    }

    synchronized void triggerRowsRemoved(int n, Object[] objectArray) {
        if (this.modelListener != null) {
            this.modelListener.modelRowsRemoved(new JKModelRowsRemovedEvent(this.model, n, objectArray));
        }
    }

    synchronized void triggerRowsReordered(int n, OSIIntVector oSIIntVector) {
        if (this.modelListener != null) {
            this.modelListener.modelRowsReordered(new JKModelRowsReorderEvent(this.model, n, oSIIntVector));
        }
    }

    synchronized void triggerColumnsChanged(String string, int n, Object[] objectArray) {
        if (this.modelListener != null) {
            this.modelListener.modelColumnsChanged(new JKModelColsChangedEvent(this.model, string, n, objectArray));
        }
    }

    synchronized void triggerColumnsAdded(String string, int n, int n2) {
        if (this.modelListener != null) {
            this.modelListener.modelColumnsAdded(new JKModelColsAddedEvent(this.model, string, n, n2));
        }
    }

    synchronized void triggerColumnsRemoved(String string, int n, Object[] objectArray) {
        if (this.modelListener != null) {
            this.modelListener.modelColumnsRemoved(new JKModelColsRemovedEvent(this.model, string, n, objectArray));
        }
    }

    synchronized void triggerColumnsReordered(String string, int n, OSIIntVector oSIIntVector) {
        if (this.modelListener != null) {
            this.modelListener.modelColumnsReordered(new JKModelColsReorderEvent(this.model, string, n, oSIIntVector));
        }
    }
}

