/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIArray;
import com.objectshare.grid.data.JKModelElemEvent;
import com.objectshare.grid.data.JKModelElemListener;
import com.objectshare.grid.data.JKModelElemMulticaster;
import com.objectshare.grid.data.JKModelElemParentEvent;
import java.io.Serializable;

public abstract class JKModelElem
implements Serializable {
    OSIArray children;
    JKModelElemListener modelElemListener;

    public boolean canHaveChildren() {
        return this.children != null;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            return this.children.toArray();
        }
        return null;
    }

    public void addChild(Object object) {
        if (this.children == null) {
            this.children = new OSIArray();
        }
        if (!this.children.contains(object)) {
            this.children.add(object);
            this.triggerChildAdded(object);
        }
    }

    public void removeChild(Object object) {
        if (this.children != null && this.children.remove(object)) {
            this.triggerChildRemoved(object);
        }
    }

    public void connect() {
    }

    public void release() {
    }

    public void addModelElemListener(JKModelElemListener jKModelElemListener) {
        if (this.modelElemListener == null && jKModelElemListener != null) {
            this.connect();
        }
        this.modelElemListener = JKModelElemMulticaster.add(this.modelElemListener, jKModelElemListener);
    }

    public void removeModelElemListener(JKModelElemListener jKModelElemListener) {
        JKModelElemListener jKModelElemListener2 = this.modelElemListener;
        this.modelElemListener = JKModelElemMulticaster.remove(this.modelElemListener, jKModelElemListener);
        if (jKModelElemListener2 != null && this.modelElemListener == null) {
            this.release();
        }
    }

    void triggerChanged() {
        this.triggerChanged(null);
    }

    void triggerChanged(String string) {
        if (this.modelElemListener != null) {
            this.modelElemListener.modelElemChanged(new JKModelElemEvent(this, string));
        }
    }

    void triggerChildAdded(Object object) {
        if (this.modelElemListener != null) {
            this.modelElemListener.modelElemChildAdded(new JKModelElemParentEvent(this, object));
        }
    }

    void triggerChildRemoved(Object object) {
        if (this.modelElemListener != null) {
            this.modelElemListener.modelElemChildRemoved(new JKModelElemParentEvent(this, object));
        }
    }
}

